<?php

namespace App\Http\Middleware;

use App\Models\Company\Company;
use App\Models\Company\GlobalCompany;
use App\Models\Menu\Menu;
use App\Models\Modules\SubModule;
use App\Models\Permission\GroupAccess;

use App\Models\Package\EduPackage;
use App\Models\Package\EduPackageModule;

use App\Models\Site\SiteInfo;
use App\Models\SiteGroup\GlobalSiteGroup;
use App\Traits\AliasUniqueCheck;
use Closure;
use Illuminate\Contracts\Auth\Guard;
use App\Models\Permission\UserExtraPermission;
use Illuminate\Support\Facades\Auth;
use Request;
use Session;

class ApiAccessMiddleware
{

    use AliasUniqueCheck;

    private $groupAccess;
    private $auth;
    private $menu;
    private $subModule;


    public function __construct(Request $request,GroupAccess $groupAccess, Menu $menu, Guard $auth, SubModule $subModule)
    {
        $this->groupAccess = $groupAccess;
        $this->menu = $menu;
        $this->auth = $auth;
        $this->subModule = $subModule;

        
    }


    public function handle($request, Closure $next)
    {
     // dd(Auth::user());
        return $next($request);
    }
}