<?php

namespace App\Http\Middleware;

use App\Models\Company\GlobalCompany;
use App\Models\Modules\SubModule;
use App\Models\Package\EduPackage;
use App\Models\Package\EduPackageModule;
use App\Models\Permission\UserExtraPermission;
use App\Models\Site\SiteInfo;
use App\Models\SiteGroup\GlobalSiteGroup;
use App\Traits\AliasUniqueCheck;
use Closure;
use App\Models\Menu\Menu;
use App\Models\Permission\GroupAccess;
use Illuminate\Contracts\Auth\Guard;
use Route;
use Session;
use Illuminate\Support\Facades\Auth;
use Response;

class GrantAccessMiddleware
{
    use AliasUniqueCheck;
    private $groupAccess;
    private $auth;
    private $menu;
    private $subModule;


    public function __construct(GroupAccess $groupAccess, Menu $menu, Guard $auth, SubModule $subModule)
    {
        $this->groupAccess = $groupAccess;
        $this->menu = $menu;
        $this->auth = $auth;
        $this->subModule = $subModule;

    }

    private function getCommonMenusForUnRegisteredUser(Menu $menu)
    {
        return $menu->where('is_common_access', true)->get();
    }

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  \Closure $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {

        if (\App::environment('local')) {
            return $next($request);
        }


        $currentRoute = Route::getRoutes()->match($request)->getName();
        $accessibleMenu = $this->menu->where('route_name', $currentRoute)->first();

        // dd($accessibleMenu);


        if ($this->auth->guest()) {//without login
            if (!$accessibleMenu) {

                if ($request->ajax() || $request->isJson()) {
                    return Response::json(['message' => 'The Route Not Inserted Yet!'], 401);
                } else {

                    return Response::make(view('web.index', [
                        'message' => 'The Route Not Inserted Yet!',
                        'title' => 'Route Not Found In DB',
                        'viewType' => 'Route Not Found In DB'
                    ]), 401);
                }
            }

            $routesForUnRegisteredUser = $this->getCommonMenusForUnRegisteredUser($this->menu)->pluck('id')->toArray();
            if (in_array($accessibleMenu->id, $routesForUnRegisteredUser)) {
                return $next($request);
            }

//======-----------------------Check web menu for guest user================------------------

            $web_menu_ids = $this->checkWebMenu($request);

            if (in_array($accessibleMenu->id, $web_menu_ids)) {
                return $next($request);
            }

            if ($request->ajax() || $request->isJson()) {
                return Response::json(['message' => 'You Are Unauthorized-' . ($accessibleMenu->id ?? 'error')], 401);
            }
        }
        // dd('d');


        if ($this->auth->check()) {//for logged in user


            $menusIdsArray = null;
            $menu_id_final = [];
            $user_type = Session::get('USER_TYPE');
            $type_id = 0;

//1===check route is inserted or not
            if (!$accessibleMenu) {//route not found in db
                if ($request->ajax() || $request->isJson()) {
                    return Response::json(['message' => 'The Route Not Inserted Yet!'], 401);
                } else {
                    return Response::make(view('default.admin.layouts.master', ['viewType' => 'Route Not Found In DB']));
                }
            }

//2===check route is common for logged in users
            $routesForAll = $this->menu
                ->where('is_logged_common_access', 1)
                ->orWhere('is_common_access', true)
                ->pluck('id')
                ->toArray();

            if ($accessibleMenu && in_array($accessibleMenu->id, $routesForAll)) {//no Auth check here as it is checked in every controller
                return $next($request);
            }

//3===check check user has role assigned to

            if (!request()->user()->roles()->first()) {
//dd(request()->user()->roles()->first());

                if ($request->ajax() || $request->isJson()) {
                    return Response::json(['message' => 'You Don"t Have Any Role! (' . request()->user()->id . '). Contact With Admin'], 401);
                } else {
                    return Response::make(view('default.no-role', [
                        'message' => 'You Don"t Have Any Role! (' . request()->user()->id . '). Contact With Admin',
                        'title' => 'You Don"t Have Any Role',
                        'viewType' => 'You Don"t Have Any Role'
                    ]), 401);
                }

            }
//3.1 if user is edu world and his role is administrator


            $user_assigned_sm_ids = array_unique(request()->user()->getSubModules());
            $extra_permission_sm_ids = (UserExtraPermission::whereUserId(Auth::user()->id)->first()->sub_module_ids) ?? null;
            $exploded_extra_permission_sm_ids = $extra_permission_sm_ids ? explode(',', $extra_permission_sm_ids) : [];
            $unique_merged_assigned_and_extra_sm_ids = array_unique(array_merge($user_assigned_sm_ids, $exploded_extra_permission_sm_ids));
            $assigned_package_sub_modules = [];

            if ($user_type == 'eduworld') {
                if (request()->user()->hasEduRole('administrator')) {
                    return $next($request);
                } else {
                    $menusIdsArray = $this->subModule->whereIn('id', $unique_merged_assigned_and_extra_sm_ids)->pluck('menu_ids');
                }
            }  elseif ($user_type == 'site') {
                //---packages sub modules
                $site_info = SiteInfo::whereId(Session::get('SITE_ID'))->first();
                $type_id = $site_info->id;

                $package = EduPackage::whereId($site_info->siteMembership->edu_package_id ?? null)->first();
                $package_module_ids = $package ? ($package->modules->pluck('id')->toArray()) : [];
                $assigned_package_sub_modules = SubModule::whereIn('module_id', $package_module_ids)->pluck('id')->toArray();


                $final_sm_ids = array_intersect($assigned_package_sub_modules, $unique_merged_assigned_and_extra_sm_ids);
                $menusIdsArray = $this->subModule->whereIn('id', $final_sm_ids)->pluck('menu_ids');
                
            }




            if ($menusIdsArray) {
             return $next($request);
            }

            //this is for logged in user global return. if nothing matched for the user he will get below code message
            if ($request->ajax() || $request->isJson()) {
                return Response::json(['message' => 'You Are Unauthorized-' . ($accessibleMenu->id ?? 'error')], 401);
            } else {
                return redirect()->route('unauthorized');
            }

        }

        //  dd('s');

        return redirect()->route('login-form');
    }


}

