<?php

namespace App\Imports\Site;

use App\Models\Site\StudentAdmission\SiteStudentAdmissionBoardApprove;
use App\Models\Site\StudentAdmission\SiteStudentAdmissionBoardApproveExcel;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;


class SiteAdmissionRollImport implements ToModel, WithHeadingRow
{
    private $rows = 0;
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {


        if ($row['board_roll_number']) {

            $data = SiteStudentAdmissionBoardApproveExcel::where('board_roll_number', $row['board_roll_number'])
                ->where('passing_year', $row['passing_year'])
                ->first();
            if (empty($data)) {
                ++$this->rows;
                return new SiteStudentAdmissionBoardApproveExcel([
                    'board_roll_number' => $row['board_roll_number'],
                    'board_registration_number' => $row['board_registration_number'],
                    'board_name' => $row['board_name'],
                    'passing_year' => $row['passing_year'],
                    'student_name' => $row['student_name'],
                    'father_name' => $row['father_name'],
                   // 'contact_number' => $row['contact_number'],
                    'mother_name' => $row['mother_name'],
                    'created_by' => \Auth::user()->id
                ]); 
            }
        }

    }


    public function getRowCount(): int
    {
        return $this->rows;
    }

}
