<?php

namespace App\Imports\Site;

use  App\Models\Site\Sms\SitePhoneBook;
use Illuminate\Validation\Rule;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class SitePhoneBookImport implements ToModel, WithHeadingRow
{

    private $rows = 0;
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {

        if ($row['mobile_number']) {

            $data = SitePhoneBook::where('mobile_number', $row['mobile_number'])->first();
            if (empty($data)) {
                ++$this->rows;
                return new SitePhoneBook([
                    'mobile_number' => $row['mobile_number'],
                    'name' => $row['name'],
                    'address' => $row['address'],
                    'created_by' => \Auth::user()->id
                ]);
            }
        }

    }


    public function getRowCount(): int
    {
        return $this->rows;
    }


}
