<?php

namespace App\Jobs\EmployeeDutyAplication;


use App\Notifications\EmployeeDutyApplication\EmployeeDutyApplicationCancelNotification ;
use App\User;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Support\Facades\Notification;

class EmployeeDutyApplicationCancelJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public $tries = 1;

    protected $employee_duty_application_cancel_details;
    protected $user_id;
    protected $route;

    public function __construct($employee_duty_application_cancel_details, $user_id, $route)
    {
        $this->employee_duty_application_cancel_details = $employee_duty_application_cancel_details;
        $this->user_id = $user_id;
        $this->route = $route;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
            $user = User::where('id', $this->user_id)->first();
            $user->notify(new EmployeeDutyApplicationCancelNotification($this->employee_duty_application_cancel_details,$this->route));



    }
}
