<?php

namespace App\Jobs\EmployeeLeaveApplication;

use App\Models\Edu\Issue\IssueDetail;
use App\Models\Site\Role\SiteRole;
use App\Models\Student\StudentHistory;
use App\Models\User\EmployeeHistory;
use App\Models\User\GlobalUser;
use App\Notifications\EmployeeLeaveApplication\EmployeeLeaveApplicationNotification;
use App\Notifications\Site\NoticeNotification;
use App\Notifications\Site\StudentDemandSlipGenerateNotification;
use App\Notifications\Site\StudentPaymentHistoryNotification;
use App\User;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Support\Facades\Notification;
use Log;

class EmployeeLeaveApplicationJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public $tries = 1;

    protected $data_array;
    protected $route;

    public function __construct($data_array, $route)
    {
        $this->data_array = $data_array;
        $this->route = $route;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {

        $user = User::where('id',  $this->data_array['admin_user_id'])
                ->select(['id'])
                ->first();

        $user->notify(new EmployeeLeaveApplicationNotification($this->data_array,$this->route));



    }
}
