<?php

namespace App\Mail\Edu;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

use App\Models\Edu\Issue\IssueDetail;
use Exception;


class SendMailToInstitute extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;


    public $tries = 2;
    public $sub;
    public $data;
    public function __construct($subject, $data)
    {
        $this->sub = $subject;
        $this->data = $data;
    }


    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function build()
    {

        $aditional_image_path = $this->data['aditional_image_path'] ?? '';

        return $this->view(
            'edu.mail.non-site-invite-credential-mail',
            [
                'main_image_path' => $this->data['main_image_path'],
                'document_desctiption' => $this->data['document_desctiption'],
                'aditional_image_path' => $aditional_image_path,
            ]
        )->subject($this->sub);
    }


    public function failed(Exception $exception)
    {

        $issue = new    IssueDetail();
        $issue->issue_type = 'mail';
        $issue->issuer_type = 'edu';
        $issue->issue_details = json_encode($exception->getMessage());
        $issue->save();
    }
}
