<?php

namespace App\Models\Academic;

use App\Models\Site\EmployeeLeave\SiteEmployeeLeaveGenerate;
use Illuminate\Database\Eloquent\Model;

class AcademicFiscalYear extends Model
{
    public $timestamps = true;
    protected $table='academic_fiscal_years';

    const YEAR_NAME = 'year_name';
    const START_DATE = 'start_date';
    const END_DATE = 'end_date';

    const STATUS = 'status';


    protected $fillable = [
        self::YEAR_NAME,
        self::START_DATE,
        self::END_DATE,
        self::STATUS
    ];

    public $ownFields = [
        self::YEAR_NAME,
        self::START_DATE,
        self::END_DATE,
        self::STATUS
    ];


    public function siteEmployeeLeaveGenerate()
    {
        return $this->hasMany(SiteEmployeeLeaveGenerate::class);
    }
}
