<?php

namespace App\Models\Academic;

use App\Models\Site\Accounts\SiteAccountsEmployeeSalary;
use Illuminate\Database\Eloquent\Model;

class AcademicMonthName extends Model
{
    public $timestamps = false;
    protected $table='academic_month_names';

    const MONTH_NAME = 'name';
    const STATUS = 'status';


    protected $fillable = [
        self::MONTH_NAME,
        self::STATUS
    ];

    public $ownFields = [
        self::MONTH_NAME,
        self::STATUS
    ];

    public function siteAccountsEmployeeSalary()
    {
        return $this->hasMany(SiteAccountsEmployeeSalary::class);
    }
}
