<?php

namespace App\Models\Academic;

use App\Models\Site\Payment\PaymentGateway;
use Illuminate\Database\Eloquent\Model;

class AcademicOnlinePaymentMarchentType extends Model
{

    public $timestamps = true;
    protected $table='academic_online_payment_marchent_types';

    const ACADEMIC_ONLINE_PAYMENT_METHOD_ID = 'academic_online_payment_method_id';
    const NAME_KEY = 'name_key';
    const NAME = 'name';
    const STATUS = 'status';




    protected $fillable = [
        self::ACADEMIC_ONLINE_PAYMENT_METHOD_ID,
        self::NAME_KEY,
        self::NAME,
        self::STATUS,

    ];

    public $ownFields = [
        self::ACADEMIC_ONLINE_PAYMENT_METHOD_ID,
        self::NAME_KEY,
        self::NAME,
        self::STATUS,


    ];

    public function paymentGateway()
    {
        return $this->hasMany(PaymentGateway::class);
    }

    public function academicOnlinePaymentMethod()
    {
        return $this->hasMany(AcademicOnlinePaymentMethod::class);
    }

    public function accOnlinePaymentMethod()
    {
        return $this->belongsTo(AcademicOnlinePaymentMethod::class, 'academic_online_payment_method_id');
    }


}