<?php

namespace App\Models\Assessment;

use App\Models\Academic\AcademicAssessmentScale;
use Illuminate\Database\Eloquent\Model;

class AssessmentResultScaleSystemSetting extends Model
{
    public $timestamps = true;
    protected $table='assessment_result_scale_system_settings';

    const Academic_assessment_scale_id = 'academic_assessment_scale_id';
    const Level_from = 'level_from';
    const Level_to = 'level_to';
    const Graph_level = 'graph_level';
    const Pass_fail_status = 'pass_fail_status';
    const Status = 'status';

    protected $fillable = [
        self::Academic_assessment_scale_id,
        self::Level_from,
        self::Level_to,
        self::Graph_level,
        self::Pass_fail_status,
        self::Status,
    ];

    public $ownFields = [
        self::Academic_assessment_scale_id,
        self::Level_from,
        self::Level_to,
        self::Graph_level,
        self::Pass_fail_status,
        self::Status,
    ];


    public function assessmentScale()
    {
        return $this->belongsTo(AcademicAssessmentScale::class,'academic_assessment_scale_id');
    }
}
