<?php

namespace App\Models\AssessmentResult;

use App\Models\Academic\AcademicAssessmentPrimaryResultType;
use App\Models\Assessment\Assessment;
use Illuminate\Database\Eloquent\Model;

class AssessmentResultPrimarySetting extends Model
{
    public $timestamps = false;
    protected $table='assessment_result_primary_settings';
    protected $appends = array('assessment_name');

    const Academic_assessment_result_primary_type_id = 'academic_assessment_result_primary_type_id';

    const Assessment_id = 'assessment_id';
    const Show_position = 'show_position';
    const Status = 'status';



    protected $fillable = [
        self::Assessment_id,
        self::Academic_assessment_result_primary_type_id,
        self::Show_position,
        self::Status,
    ];

    public $ownFields = [
        self::Assessment_id,
        self::Academic_assessment_result_primary_type_id,
        self::Show_position,
        self::Status,
    ];

    public function getAssessmentNameAttribute()
    {
        return $this->attributes['assessment_name'] = $this->assessment->assessment_name ?? '';
    }

    public function academicAssessmentPrimaryResultType()
    {
        return $this->belongsTo(AcademicAssessmentPrimaryResultType::class,'academic_assessment_result_primary_type_id');
    }
    public function assessment()
    {
        return $this->belongsTo(Assessment::class,'assessment_id');
    }
}
