<?php

namespace App\Models\Attendance;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicSection;
use App\Models\ProjectModel;
use App\Models\SiteGlobalModel;
use App\Models\Student\StudentHistory;
use App\Models\User\User;

class StudentAttendance extends SiteGlobalModel
{

    protected $table = 'student_attendances';
    public $timestamps = true;


    protected $casts = [
        'in_sms_id' => 'integer',
        'late_status' => 'integer'
    ];


    const STUDENT_HISTORY_ID = 'student_history_id';
    const ROUTINE_ALLOCATION_ID = 'routine_allocation_id';
    const SHIFT_DETAILS_ID = 'site_shift_details_id';
    const ROLL_NO = 'roll_no';
    const PRESENT_TYPE = 'present_type';
    const PRESENT_TYPE_ID = 'present_type_id';
    const IN_TIME = 'in_time';
    const OUT_TIME = 'out_time';
    const ATTENDANCE_DATE = 'present_date';
    const ATTENDANCE_DATE_TIME = 'present_date_time';
    const ATTENDANCE_YEAR = 'present_year';
    const ATTENDANCE_MONTH = 'present_month';
    const ATTENDANCE_DAY = 'present_day';
    const OFF_DAY_ATT = 'off_day_att';
    const NOTE = 'note';
    const STUDENT_CLASS = 'student_class';
    const SECTION = 'section';
    const SUBJECT = 'subject';
    const LATE_STATUS = 'late_status';


    protected $fillable = [
        self::STUDENT_HISTORY_ID,
        self::ROUTINE_ALLOCATION_ID,
        self::SHIFT_DETAILS_ID,
        self::ROLL_NO,
        self::PRESENT_TYPE,
        self::PRESENT_TYPE_ID,
        self::IN_TIME,
        self::OUT_TIME,
        self::ATTENDANCE_DATE,
        self::ATTENDANCE_YEAR,
        self::ATTENDANCE_MONTH,
        self::ATTENDANCE_DAY,
        self::OFF_DAY_ATT,
        self::NOTE,
        self::ATTENDANCE_DATE_TIME,
        self::LATE_STATUS,
    ];

    public $ownFields = [
        self::STUDENT_HISTORY_ID,
        self::ROUTINE_ALLOCATION_ID,
        self::SHIFT_DETAILS_ID,
        self::ROLL_NO,
        self::PRESENT_TYPE,
        self::PRESENT_TYPE_ID,
        self::IN_TIME,
        self::OUT_TIME,
        self::ATTENDANCE_DATE,
        self::ATTENDANCE_YEAR,
        self::ATTENDANCE_MONTH,
        self::ATTENDANCE_DAY,
        self::OFF_DAY_ATT,
        self::NOTE,
        self::ATTENDANCE_DATE_TIME,
        self::LATE_STATUS
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function academicClass()
    {
        return $this->belongsTo(AcademicClass::class);
    }

    public function academicSection()
    {
        return $this->belongsTo(AcademicSection::class);
    }

    public function scopePresentByDate($query, $date)
    {
        return $query->where('present_date',$date);
    }


// this will be deprecated
    public function userHistory()
    {
        return $this->belongsTo(StudentHistory::class, self::STUDENT_HISTORY_ID);
    }


    public function studentHistory()
    {
        return $this->belongsTo(StudentHistory::class, self::STUDENT_HISTORY_ID);
    }


    public function updateBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }


}
