<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 6/6/2016
 * Time: 11:25 AM
 */

namespace App\Models\Book;


use App\Models\ProjectModel;
use Illuminate\Database\Eloquent\SoftDeletes;
use Dimsav\Translatable\Translatable;
use App\Models\Book\BookCategory;
use App\Models\Author\Author;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class Book extends ProjectModel
{
    // use
    // SoftDeletes,
    //  Translatable
    // ;



    protected $table = 'books';

    public $timestamps = false;
    protected $dates = ['deleted_at'];

    const BOOK_CATEGORY      = 'book_category_id';
    const AUTHOR_ID          = 'author_id';
    const SUBJECT_CODE       = 'subject_code';
    const BOOK               = 'book_name';
    const BOOK_PRICE         = 'book_price';
    const QUANTITY           = 'quantity';
    const RACK_NO            = 'rack_no';
    const RACK_ID            = 'book_reck_id';
    const STATUS             = 'status';
    const TITLE              = 'title';
    const SUBJECT            = 'subject';
    const CATEGORY_ID        = 'category_id';
    const SUB_CATEGORY_ID    = 'sub_category_id';
    const ISBN               = 'isbn';
    const PAGES              = 'pages';
    const YEAR               = 'year';
    const PUBLISHER          = 'publisher';
    const AVAILABLE_QUANTITY = 'available_quantity';
    const LOCATION           = 'location';
    const CONDITION          = 'condition';
    const SALE_STATUS        = 'sale_status';
    const PRICE              = 'price';
    const NOTES              = 'notes';
    const DAMAGE_INFO        = 'damage_info';



    protected $fillable = [
        self::BOOK_CATEGORY,
        self::AUTHOR_ID,
        self::SUBJECT_CODE,
        self::BOOK,
        self::BOOK_PRICE,
        self::QUANTITY,
        self::RACK_NO,
        self::STATUS,
        self::TITLE,
        self::SUBJECT,
        self::CATEGORY_ID,
        self::SUB_CATEGORY_ID,
        self::RACK_ID,
        self::ISBN,
        self::PAGES,
        self::YEAR,
        self::PUBLISHER,
        self::AVAILABLE_QUANTITY,
        self::LOCATION,
        self::CONDITION,
        self::SALE_STATUS,
        self::PRICE,
        self::NOTES,
        self::DAMAGE_INFO,
    ];
    protected $ownFields = [
        self::BOOK_CATEGORY,
        self::AUTHOR_ID,
        self::SUBJECT_CODE,
        self::RACK_ID,
        self::BOOK,
        self::BOOK_PRICE,
        self::QUANTITY,
        self::RACK_NO,
        self::STATUS,
        self::TITLE,
        self::SUBJECT,
        self::CATEGORY_ID,
        self::SUB_CATEGORY_ID,
        self::ISBN,
        self::PAGES,
        self::YEAR,
        self::PUBLISHER,
        self::AVAILABLE_QUANTITY,
        self::LOCATION,
        self::CONDITION,
        self::SALE_STATUS,
        self::PRICE,
        self::NOTES,
        self::DAMAGE_INFO,
    ];
    public function scopeIncludeTrashed($query)
    {
        return $query->withTrashed();
    }

    public $translatedAttributes = [
        self::BOOK
    ];

    // Book belongsTo BookCategory
    public function bookCategory()
    {
        return $this->belongsTo(BookCategory::class, 'category_id');
    }

    // Book belongsTo Author
    public function bookAuthor()
    {
        return $this->belongsTo(Author::class, 'author_id');
    }
    public function bookRack()
    {
        return $this->belongsTo(BookReck::class, 'book_reck_id');
    }

    public function bookHistory()
    {
        return $this->hasMany(LibraryBookHistory::class);
    }

}
