<?php

namespace App\Models\Company\Role;

use App\Models\Company\CompanyProjectModel;
use App\Models\Company\CompanyUser;

class CompanyRole extends CompanyProjectModel
{
    protected $table='company_roles';


    public $timestamps = true;

    const NAME = 'name';
    const KEY = 'key';
    const ROLE_DESCRIPTION = 'role_description';
    const COMPANY_ID = 'company_id';
    const STATUS = 'status';


    protected $fillable = [

        self::NAME,
        self::KEY,
        self::ROLE_DESCRIPTION,
        self::COMPANY_ID,
        self::STATUS,
    ];
    public $ownFields = [

        self::NAME,
        self::KEY,
        self::ROLE_DESCRIPTION,
        self::COMPANY_ID,
        self::STATUS,
    ];



    public function users()
    {
        return $this->belongsToMany(CompanyUser::class,'company_role_users', 'company_role_id', 'user_id');
    }

    public function roleAccess(){
        return $this->hasOne(GlobalCompanyRoleAccess::class,'company_role_id');
    }


}
