<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 5/7/2016
 * Time: 11:07 AM
 */
namespace App\Models\Country;

use App\Models\ProjectModel;
use App\Models\Thana\Thana;
use App\Models\Upozela\Upozela;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Dimsav\Translatable\Translatable;
use App\Models\Division\Division;
use App\Models\District\District;
use App\Models\Training\Training;

class Country extends Model
{
   // use SoftDeletes;
    use  Translatable;
    public $translationModel = CountryTranslation::class;
    public $translationForeignKey = 'country_id';

    protected $table='countries';

    const NAME = 'country_name';
    const STATUS = 'status';
    const CODE = 'govt_code';
    const DIVISION_CHECK = 'division_check';


    public $timestamps = false;

    protected $dates = ['deleted_at'];

    protected $fillable = [
        self::NAME,
        self::STATUS,
        self::CODE,
        self::DIVISION_CHECK,

    ];

    public $ownFields = [
        self::NAME,
        self::STATUS,
        self::CODE,
        self::STATUS,
        self::DIVISION_CHECK,
    ];
   public $translatedAttributes = [self::NAME];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function divisions()
    {
        return $this->hasMany(Division::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function districts()
    {
        return $this->hasMany(District::class);
    }

    public function thanas()
    {
        return $this->hasMany(Thana::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function training()
    {
        return $this->hasMany(Training::class);
    }
}