<?php

namespace App\Models\Designation;

use App\Models\Department\Department;
use App\Models\ProjectModel;
use App\Models\Site\EmployeeLeave\SiteLeavePolicy;
use App\Models\User\EmployeeHistory;
use App\User;
use Illuminate\Database\Eloquent\Model;

//class Designation extends ProjectModel
class Designation extends Model
{
    protected $table='designations';

    const NAME = 'name';
    const STATUS ='status';
    const POSITION = 'position';

    public $timestamps = false;

    protected $fillable = [
        self::NAME,
        self::STATUS,
        self::POSITION
    ];
    protected $ownfields = [
        self::NAME,
        self::STATUS,
        self::POSITION
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
//    public function department()
//    {
//        return $this->belongsTo(Department::class);
//    }

    /**
     * many users with one designation
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function users()
    {
        return $this->hasMany(User::class);
    }

    public function siteLeavePolicy()
    {
        return $this->hasMany(SiteLeavePolicy::class);
    }

    public function employeeHistory()
    {
        return $this->hasMany(EmployeeHistory::class);
    }

}
