<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 5/7/2016
 * Time: 2:59 PM
 */
namespace App\Models\Division;

use App\Models\ProjectModel;
use App\Models\Thana\Thana;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Dimsav\Translatable\Translatable;
use App\Models\Country\Country;
use App\Models\District\District;

class Division extends Model
{
    use SoftDeletes, Translatable;

    public $translationModel = DivisionTranslation::class;
    public $translationForeignKey = 'division_id';


    const COUNTRY = 'country_id';
    const NAME = 'division_name';
    const CODE = 'govt_code';
    const STATUS = 'status';
    const DISTRICT_CHECK = 'district_check';

    public $timestamps = false;

    protected $dates = ['deleted_at'];

    protected $fillable = [
        self::COUNTRY,
        self::NAME,
        self::CODE,
        self::STATUS,
        self::DISTRICT_CHECK,
    ];

    public $ownFields = [
        self::COUNTRY,
        self::NAME,
        self::CODE,
        self::STATUS,
        self::DISTRICT_CHECK,
    ];
    public $translatedAttributes = [self::NAME];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function country()
    {
        return $this->belongsTo(Country::class,'country_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function district()
    {
        return $this->hasMany(District::class);
    }

    public function thana()
    {
        return $this->hasMany(Thana::class);
    }
}