<?php

namespace App\Models\Edu\ClassRoom;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicGroup;
use App\Models\Site\Web\ClassRoom\ClassRoomTranslation;
use App\Models\Site\Web\ClassRoom\WebsiteClassRoomLink;
use Illuminate\Database\Eloquent\Model;

use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicSubject;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Image\Photo;
use App\Models\ProjectModel;
use App\Models\SiteGlobalModel;
use App\User;
use Dimsav\Translatable\Translatable;

class EduClassRoom extends Model
{

    use  Translatable;
    public $translationModel = ClassRoomTranslation::class;
    public $translationForeignKey = 'website_class_room_id';

    public $timestamps = true;
    protected $table = 'website_class_rooms';
    protected $dates = ['created_at','updated_at', 'publish_date'];

    protected $casts = ['status' => 'integer'];

    const ENTRY_TYPE = 'entry_type';
    const TOPIC_TITLE = 'topic_title';
    const TOPIC_DESCRIPTION = 'topic_description';
    const SERIAL_NO = 'serial_no';
    const ACADEMIC_VERSION_ID = 'academic_version_id';
    const ACADEMIC_YEAR_ID = 'academic_year_id';
    const ACADEMIC_SHIFT_ID = 'academic_shift_id';
    const ACADEMIC_CLASS_ID = 'academic_class_id';
    const ACADEMIC_DEPARTMENT_ID = 'academic_department_id';
    const ACADEMIC_SUBJECT_ID = 'academic_subject_id';
    const FACULTY_ID = 'faculty_id';
    const ENTRY_DATE = 'entry_date';
    const PUBLISH_DATE = 'publish_date';
    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const CREATED_BY = 'created_by';
    const PAUSE_STATUS = 'pause_status';
    const STATUS = 'status';
    const APPROVE_STATUS = 'approve_status';
    const PUBLISH_TO = 'publish_to';




    protected $fillable = [
        self::ENTRY_TYPE,
        self::TOPIC_TITLE,
        self::TOPIC_DESCRIPTION,
        self::SERIAL_NO,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_SUBJECT_ID,
        self::FACULTY_ID,
        self::ENTRY_DATE,
        self::PUBLISH_DATE,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::CREATED_BY,
        self::PAUSE_STATUS,
        self::STATUS,
        self::APPROVE_STATUS,
        self::PUBLISH_TO,

    ];

    public $translatedAttributes = [
        self::TOPIC_TITLE,
        self::TOPIC_DESCRIPTION,
    ];


    public $ownFields = [
        self::ENTRY_TYPE,
        self::TOPIC_TITLE,
        self::TOPIC_DESCRIPTION,
        self::SERIAL_NO,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_SUBJECT_ID,
        self::FACULTY_ID,
        self::ENTRY_DATE,
        self::PUBLISH_DATE,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::CREATED_BY,
        self::PAUSE_STATUS,
        self::STATUS,
        self::APPROVE_STATUS,
        self::PUBLISH_TO,
    ];




    public function files()
    {
        return $this->morphMany(Photo::class, 'imageable');

    }

    public function user()
    {
        return $this->belongsTo(User::class, 'faculty_id');

    }

    public function websiteClassRoomLink()
    {
        return $this->hasMany(WebsiteClassRoomLink::class, 'website_class_room_id');

    }

    public function academicClass()
    {
        return $this->belongsTo(AcademicClass::class);
    }

    public function academicSubject()
    {
        return $this->belongsTo(AcademicSubject::class);
    }

    public function academicDepartment()
    {
        return $this->belongsTo(AcademicDepartment::class);
    }

    public function academicGroup()
    {
        return $this->belongsTo(AcademicGroup::class);
    }

    public function academicYear()
    {
        return $this->belongsTo(AcademicYear::class);
    }
}
