<?php

namespace App\Models\Edu\Holiday;

use App\Models\Country\Country;
use App\Models\Holydays\Holyday;
use Illuminate\Database\Eloquent\Model;

class HolidayForSite extends Model
{

    public $timestamps = false;
    protected $table='holiday_for_sites';

    const COUNTRY_ID = 'country_id';
    const YEAR = 'year';
    const HOLIDAY_ID = 'holyday_id';
    const EVENT_TYPE = 'event_type';
    const START_DATE = 'start_date';
    const END_DATE = 'end_date';
    const ACTIVE_DATE = 'activate_date';
    const IDENTIFICATION_NUMBER = 'identification_number';
    const TITLE = 'title';
    const DAY_NAME = 'day_name';
    const DESCRIPTION = 'description';
    const STATUS = 'status';


    protected $fillable = [
        self::COUNTRY_ID,
        self::YEAR,
        self::HOLIDAY_ID,
        self::EVENT_TYPE,
        self::START_DATE,
        self::END_DATE,
        self::ACTIVE_DATE,
        self::IDENTIFICATION_NUMBER,
        self::TITLE,
        self::DAY_NAME,
        self::DESCRIPTION,
        self::STATUS
    ];

    public $ownFields = [
        self::COUNTRY_ID,
        self::YEAR,
        self::HOLIDAY_ID,
        self::EVENT_TYPE,
        self::START_DATE,
        self::END_DATE,
        self::ACTIVE_DATE,
        self::IDENTIFICATION_NUMBER,
        self::TITLE,
        self::DAY_NAME,
        self::DESCRIPTION,
        self::STATUS
    ];

    public function holyday()
    {
        return $this->belongsTo(Holyday::class);
    }
    public function country()
    {
        return $this->belongsTo(Country::class);
    }

}
