<?php

namespace App\Models\Edu\Issue;

use Illuminate\Database\Eloquent\Model;

class IssueDetail extends Model
{
    protected $table = 'edu_issue_details';
    public $timestamps = true;


    const USERNAME = 'username';
    const ISSUE_TYPE = 'issue_type';
    const ISSUE_DETAILS = 'issue_details';
    const BEARER_TYPE = 'bearer_type';
    const BEARER_ID = 'bearer_id';

    const ACCESS_TIME = 'access_time';
    const ATTENDANCE_DATE = 'attendance_date';
    const DEVICE_ID = 'device_id';
    const ACCESS_ID = 'access_id';
    const ISSUER_TYPE = 'issuer_type';//use bearer_type instead--deleted

    const IP_ADDRESS = 'ip_address';
    const Issue_details = 'issue_details';
    const SITE_ID = 'site_id'; //use bearer_id instead--deleted


    protected $fillable = [
        self::USERNAME,
        self::ISSUE_TYPE,
        self::BEARER_TYPE,
        self::BEARER_ID,
        self::ISSUE_DETAILS,
        self::ISSUER_TYPE,
        self::IP_ADDRESS,
        self::Issue_details,
        self::SITE_ID,
    ];




    protected static function boot()
    {
        parent::boot();

        static::saving(function($model)
        {
            $model->ip_address = \Request::getClientIp();
        });
    }



  /*  public function setIpAddressAttribute($value)
    {
        $this->attributes['ip_address'] = \Request::ip();
    }*/


/*
$issue = new    IssueDetail();
$issue->bearer_type = $req_data['bearer_type'] ??  'edu';
$issue->bearer_id = $req_data['bearer_id'] ?? null;
$issue->username = $edu_user_name; //or any unique value--can be null too
$issue->issue_type = 'api:trans-check';
$issue->issue_details = "exception: verifyOnlineTransId: " . json_encode($exception->getMessage());
$issue->ip_address = Request::ip();
$issue->save();*/






}
