<?php

namespace App\Models\Edu\NonSite;

use App\Models\Academic\AcademicEducationLevel;
use App\Models\Academic\AcademicInstituteManagementType;
use App\Models\District\DistrictTranslation;
use App\Models\Division\Division;
use App\Models\Division\DivisionTranslation;
use App\Models\Gender\Gender;
use App\Models\Gender\GenderTranslation;
use App\Models\Thana\ThanaTranslation;
use Illuminate\Database\Eloquent\Model;

class AllInstituteListExcel extends Model
{
    public $timestamps = true;
    protected $table='all_institute_list_excels';


    const Division = 'division';
    const District = 'district';
    const Thana = 'thana';
    const Eiin = 'eiin';
    const Institution_name = 'institution_name';
    const Academic_education_level = 'academic_education_level';
    const Academic_institute_management_type = 'academic_institute_management_type';
    const Institution_mobile = 'institution_mobile';
    const Institution_email = 'institution_email';
    const Gender = 'gender';
    const Accepted_as_site = 'accepted_as_site';
    const Status = 'status';



    protected $fillable = [
        self::Division,
        self::District,
        self::Thana,
        self::Eiin,
        self::Institution_name,
        self::Academic_education_level,
        self::Academic_institute_management_type,
        self::Institution_mobile,
        self::Institution_email,
        self::Gender,
        self::Accepted_as_site,
        self::Status,
    ];

    public $ownFields = [
        self::Division,
        self::District,
        self::Thana,
        self::Eiin,
        self::Institution_name,
        self::Academic_education_level,
        self::Academic_institute_management_type,
        self::Institution_mobile,
        self::Institution_email,
        self::Gender,
        self::Accepted_as_site,
        self::Status,
    ];


    public function divisionlist()
    {
        return $this->belongsTo(DivisionTranslation::class, 'division', 'division_name');
    }


    public function districtlist()
    {
        return $this->belongsTo(DistrictTranslation::class, 'district', 'district_name');
    }

    public function thanalist()
    {
        return $this->belongsTo(ThanaTranslation::class, 'thana', 'thana_name');
    }




    public function getAcademicEducationLevelAttribute($values)
    {
        return  $this->attributes['academic_education_level']=  AcademicEducationLevel::where('name_key',strtolower(str_replace(' ', '', $values)))
            ->first();

    }


    public function getAcademicInstituteManagementTypeAttribute($values)
    {
        return  $this->attributes['academic_institute_management_type']=  AcademicInstituteManagementType::where('name_key',strtolower(str_replace(' ', '', $values)))
            ->first();

    }

    public function getGenderAttribute($values)
    {
        return  $this->attributes['gender']=  Gender::where('head_key',strtolower(str_replace(' ', '', $values)))
            ->first();

    }



}
