<?php

namespace App\Models\Edu\SMS;

use App\Models\Site\SiteInfo;
use Illuminate\Database\Eloquent\Model;

class SmsFollowUp extends Model
{
    protected $table = 'edu_sms_follow_ups';
    public $timestamps = true;
    
    const MSG_ID = 'res_msg_id';
    const MSG_TXT = 'msg_txt';
    const RES_TXT_JSON = 'res_txt_json';
    const COMPANY = 'company';
    const MSG_NUMBERS = 'msg_numbers';
    const STATUS = 'res_status';
    const ERROR_CODE= 'res_error_code';
    const ERROR_TXT = 'res_error_txt';
    const SMS_COUNT = 'res_sms_count';
    const CURRENT_CREDIT = 'res_current_credit';
    const TYPE = 'institution_type';
    const EDU_CHARGED = 'edu_charged_from_client';
    const COMPANY_CHARGED = 'company_charged_from_edu';
    const ID = 'institution_id';
    const Sent_masking = 'sent_masking';
    const Sent_status = 'sent_status';
    const Returned_charges = 'returned_charges';


    protected $fillable = [
        self::MSG_ID,
        self::MSG_TXT,
        self::COMPANY,
        self::MSG_NUMBERS,
        self::STATUS,
        self::ERROR_TXT,
        self::ERROR_CODE,
        self::SMS_COUNT,
        self::CURRENT_CREDIT,
        self::TYPE,
        self::ID,
        self::EDU_CHARGED,
        self::COMPANY_CHARGED,
        self::RES_TXT_JSON,
        self::Sent_masking,
        self::Sent_status,
        self::Returned_charges,
    ];

  /*  public $ownFields = [
        self::MSG_ID,
        self::MSG_TXT,
        self::COMPANY,
        self::MSG_NUMBERS,
        self::STATUS_TXT,
        self::STATUS,
        self::ERROR_TXT,
        self::ERROR_CODE,
        self::SMS_COUNT,
        self::CURRENT_CREDIT,
        self::TYPE,
        self::ID,
    ];*/




    public function getMsgTxtAttribute($value)
    {
        return  str_replace("nl", " ", $value);
    }



    public function site()
    {
        return $this->belongsTo(SiteInfo\GlobalSiteInfo::class,'institution_id');
    }



/*
   public function getInstitutionIdAttribute($value)
    {

        return  SiteInfo::where('id',$value)->first()->site_name ?? '';


      //  return $this->belongsTo(SiteInfo::class,'site_id');
    }*/

}
