<?php

namespace App\Models\Edu\SitePayment;

use App\Models\Site\SiteInfo;
use Illuminate\Database\Eloquent\Model;

class SiteInvoice extends Model
{


    public $timestamps = true;
    protected $table = 'edu_site_invoices';

    protected $appends = array('carried_invoice_no');


    protected $casts = [
        'order_id' => 'integer',
        'carried_invoice_id' => 'integer',
        'invoice_no' => 'string',
        'amount_due' => 'double',
        'amount_paid' => 'double',


        'notify' => 'string',
        'site_id' => 'integer',
        'status_code' => 'string',
        'status' => 'integer',
    ];

    const ORDER_ID = 'order_id';
    const INVOICE_NO = 'invoice_no';
    const CARRIED_INVOICE_ID = 'carried_invoice_id';
    const INVOICE_DATE = 'invoice_date';
    const DUE_DATE = 'due_date';
    const SUB_TOTAL = 'sub_total';
    const TAX_PERCENTAGE = 'tax_percentage';
    const TOTAL_TAX = 'total_tax';
    const TOTAL_AFTER_TAX = 'total_after_tax';
    const DISCOUNT_TYPE = 'discount_type';
    const DISCOUNT_FIGURE = 'discount_figure';
    const DISCOUNT_AMOUNT = 'discount_amount';
    const PREVIOUS_DUE = 'previous_due';
    const GRAND_TOTAL = 'grand_total';
    const AMOUNT_PAID = 'amount_paid';
    const AMOUNT_DUE = 'amount_due';
    const NOTIFY = 'notify';
    const NOTE = 'note';
    const STATUS_CODE = 'status_code';
    const SITE_ID = 'site_id';
    const STATUS = 'status';


    protected $dates = ['deleted_at'];

    protected $fillable = [
        self::ORDER_ID,
        self::INVOICE_NO,
        self::CARRIED_INVOICE_ID,
        self::INVOICE_DATE,
        self::DUE_DATE,
        self::SUB_TOTAL,
        self::TAX_PERCENTAGE,
        self::TOTAL_TAX,
        self::TOTAL_AFTER_TAX,
        self::DISCOUNT_TYPE,
        self::DISCOUNT_FIGURE,
        self::DISCOUNT_AMOUNT,
        self::PREVIOUS_DUE,
        self::GRAND_TOTAL,
        self::STATUS_CODE,
        self::NOTIFY,
        self::NOTE,
        self::SITE_ID,
        self::STATUS
    ];
    public $ownFields = [
        self::ORDER_ID,
        self::INVOICE_NO,
        self::INVOICE_DATE,
        self::DUE_DATE,
        self::SUB_TOTAL,
        self::TAX_PERCENTAGE,
        self::TOTAL_TAX,
        self::TOTAL_AFTER_TAX,
        self::DISCOUNT_TYPE,
        self::DISCOUNT_FIGURE,
        self::DISCOUNT_AMOUNT,
        self::PREVIOUS_DUE,
        self::GRAND_TOTAL,
        self::STATUS_CODE,
        self::NOTIFY,
        self::NOTE,
        self::SITE_ID,
        self::STATUS
    ];


    //mutator
    public function getCarriedInvoiceNoAttribute()
    {
        return  $this->attributes['carried_invoice_no']= ($this->carriedInvoice->invoice_no ?? 0);

    }

    public function getStatusCodeAttribute($value)
    {
        return ucwords($value);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */

    //mutator
    public function carriedInvoice()
    {
        return $this->belongsTo(SiteInvoice::class, 'carried_invoice_id');

    }

    public function siteInfo()
    {
        return $this->belongsTo(SiteInfo::class, self::SITE_ID);
    }

    public function payments()
    {
        return $this->hasMany(EduInvoicePayment::class, 'invoice_id');
    }
    public function histories()
    {
        return $this->hasMany(SiteInvoiceHistory::class, 'invoice_id');
    }

    public function details()
    {
        return $this->hasMany(SiteInvoiceDetail::class, 'invoice_id');
    }




    public function getPreviousDueAttribute($value)
    {

       // dd($this->previous_due);
        return $value ?? 0;
    }

    public function getAmountDueAttribute()
    {
        $paid = $this->payments
            ->where('status_code', 'Approved')
            ->sum('paid_amount');


        $due = ($this->grand_total - $paid);




        return $due ?? 0;
    }

    public function getAmountPaidAttribute()
    {
        $paid = $this->payments->where('status_code', 'Approved')->sum('paid_amount');
        return $paid ?? 0;
    }


    /*
   * Get the movies that has up votes
   *
   */
    public function scopePaidAmount($query)
    {
        return $query->whereHas('payments', function ($voteQuery) {
            $voteQuery->where('status_code', 'approved');
        });
    }


}
