<?php

namespace App\Models\Edu\SitePayment;

use App\Models\Academic\AcademicMonthName;
use App\Models\Edu\Item\ItemDetail;
use Illuminate\Database\Eloquent\Model;

class SiteInvoiceDetail extends Model
{

    public $timestamps = true;
    protected $table = 'edu_site_invoice_details';


    protected $casts = [
        'invoice_id' => 'integer',
        'item_details_id' => 'integer',
        'item_final_amount' => 'integer'
    ];


    const INVOICE_ID = 'invoice_id';
    const ITEM_DETAILS_ID = 'item_details_id';
    const MONTH_FOR = 'month_for';
    const ITEM_QUANTITY = 'item_quantity';
    const ITEM_PRICE = 'item_price';
    const TAX_PERCENTAGE = 'tax_percentage';
    const TOTAL_TAX = 'total_tax';
    const FINAL_AMOUNT = 'item_final_amount';



    protected $fillable = [
        self::INVOICE_ID,
        self::ITEM_DETAILS_ID,
        self::MONTH_FOR,
        self::ITEM_QUANTITY,
        self::ITEM_PRICE,
        self::TAX_PERCENTAGE,
        self::TOTAL_TAX,
        self::FINAL_AMOUNT,
    ];


    public $ownFields = [
        self::MONTH_FOR,
        self::ITEM_QUANTITY,
        self::ITEM_PRICE,
        self::TAX_PERCENTAGE,
        self::TOTAL_TAX,
        self::FINAL_AMOUNT,
    ];


    public function item()
    {
        return $this->belongsTo(ItemDetail::class, self::ITEM_DETAILS_ID);
    }


    public function month()
    {
        return $this->belongsTo(AcademicMonthName::class, self::MONTH_FOR);
    }


}
