<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 5/4/2016
 * Time: 2:22 PM
 */
namespace App\Models\Examinations;

use App\Models\ProjectModel;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Examinations\ExaminationSchedule;

class Examination extends Model
{
    //use SoftDeletes;

    public $timestamps = false;
    protected $table = 'examinations';

    const EXAMINATION_NAME = 'examination_name';
    const EXAMINATION_NOTE = 'examination_note';
    const Name_key = 'name_key';
    const Use_key = 'use_key';
    const STATUS = 'status';

    protected $fillable = [
        self::EXAMINATION_NAME,
        self::Name_key,
        self::Use_key,
        self::EXAMINATION_NOTE,
        self::STATUS
    ];

    protected $dates = ['deleted_at'];

    // Examination hasMany ExaminationSchedule
    public function examinationSchedules()
    {
        return $this->hasMany(ExaminationSchedule::class);
    }
}