<?php

namespace App\Models\Menu;

use App\Models\Permission\GroupAccess;
use App\Models\ProjectModel;
use App\Models\Site\SiteAccess;
use App\Models\Site\SiteInfo;
use App\Models\WebSite\WebsiteMenu;
use Dimsav\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\SiteGlobalModel;


//class Menu extends ProjectModel
class Menu extends Model
{
  

    ////
    use Translatable;

    ////
    public $translationModel = MenuTranslation::class;
    public $translationForeignKey = 'menu_id';

    public $timestamps = false;
    protected $table = 'menus';
   // protected $dates = ['deleted_at'];
    protected $dates = ['created_at','updated_at'];

    /////

    const MENU_NAME = 'menu_name';
    const MENU_FOR = 'menu_for';
    const MENU_FORS = 'menu_fors';
    const ICON = 'icon_name';
    const ROUTE_NAME = 'route_name';
    const NOTE = 'note';
    const PARENT_ID = 'parent_id';
    const POSITION = 'position';
    const STATUS = 'status';
    const IS_COMMON_ACCESS = 'is_common_access';
    const IS_LOGGED_COMMON_ACCESS = 'is_logged_common_access';
    const IS_DISPLAYABLE = 'is_displayable';

    protected $fillable = [
        self::MENU_NAME,
        self::MENU_FOR,
        self::MENU_FORS,
        self::ROUTE_NAME,
        self::NOTE,
        self::ICON,
        self::PARENT_ID,
        self::POSITION,
        self::STATUS,
        self::IS_DISPLAYABLE,
        self::IS_COMMON_ACCESS,
        self::IS_LOGGED_COMMON_ACCESS
    ];

    public $translatedAttributes = [
        self::MENU_NAME
    ];

    public $ownFields = [
        self::MENU_NAME,
        self::MENU_FOR,
        self::MENU_FORS,
        self::ROUTE_NAME,
        self::NOTE,
        self::ICON,
        self::PARENT_ID,
        self::POSITION,
        self::STATUS,
        self::IS_DISPLAYABLE,
        self::IS_COMMON_ACCESS,
        self::IS_LOGGED_COMMON_ACCESS
    ];

    /* public function getStatusAttribute($value){

         return $value? 'Active': 'Inactive';
     }*/

 


    public function getMenuForsAttribute($val)
    {
        return $this->attributes['menu_fors'] = $val ?  explode(',', $val): [];

    }


    public function setMenuForsAttribute($val)
    {
        $this->attributes['menu_fors'] = $val ? implode(',', $val) : "";

    }


    public function groupAccess()
    {
        return $this->hasMany(GroupAccess::class);
    }

    public function siteAccess()
    {
        return $this->belongsToMany(SiteInfo::class, 'site_accesses', 'menu_id', 'site_id');
    }


    public function childMenu()
    {
        return $this->hasMany(Menu::class, 'parent_id');
    }

    public function child()
    {
        return $this->hasMany(Menu::class, 'parent_id');
    }

    public function web()
    {
        return $this->hasOne(WebsiteMenu::class, 'menu_id');
    }

    /**
     * Get the routes for the menu.
     */
    public function routes()
    {
        return $this->hasMany(MenuUsingRoute::class);
    }

    public function routesForInsert()//this method is only for save or update table easily
    {
        return $this->belongsToMany(Menu::class, 'menu_using_routes', 'menu_id', 'route_id');
    }


}
