<?php

namespace App\Models\Site\Accounts;

use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class Accounts extends SiteGlobalModel
{
    public $timestamps = true;
    protected $table='site_accounts';

    const SITE_ACCOUNTS_LEDGER_ID = 'site_accounts_ledger_id';
    const SITE_ACCOUNTS_VOUCHER_DETAILS_ID = 'site_accounts_voucher_detail_id';
    const DEBIT_AMOUNT = 'debit_amount';
    const CREDIT_AMOUNT = 'credit_amount';
    const ENTRY = 'entry';
    const SITE_ID = 'site_id';
    const SITE_GROUP_ID = 'site_group_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const CREATED_BY = 'created_by';
    const CREATED_DATE = 'created_date';
    const STATUS = 'status';
    const PROPRIETOR_ACCESS_KEY = 'proprietor_access_key';



    protected $fillable = [
        self::SITE_ACCOUNTS_LEDGER_ID,
        self::SITE_ACCOUNTS_VOUCHER_DETAILS_ID,
        self::DEBIT_AMOUNT,
        self::CREDIT_AMOUNT,
        self::ENTRY,
        self::SITE_ID,
        self::SITE_GROUP_ID,
        self::ACADEMIC_GROUP_ID,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::STATUS,
        self::PROPRIETOR_ACCESS_KEY,
    ];

    public $ownFields = [
        self::SITE_ACCOUNTS_LEDGER_ID,
        self::SITE_ACCOUNTS_VOUCHER_DETAILS_ID,
        self::DEBIT_AMOUNT,
        self::CREDIT_AMOUNT,
        self::ENTRY,
        self::SITE_ID,
        self::SITE_GROUP_ID,
        self::ACADEMIC_GROUP_ID,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::STATUS,
        self::PROPRIETOR_ACCESS_KEY,

    ];

    public function accountsVoucherDetails()
    {
        return $this->hasMany(AccountsVoucherDetails::class);
    }

    public function accVoucherDetails()
    {
        return $this->belongsTo(AccountsVoucherDetails::class, 'site_accounts_voucher_detail_id');
    }
    public function ledger()
    {
        return $this->belongsTo(Ledger::class,'site_accounts_ledger_id');
    }
    public function siteAccountsVoucherDetailsBankAccountDepositRecord()
    {
        return $this->hasOne(SiteAccountsVoucherDetailsBankAccountDepositRecord::class,'site_account_id');
    }
    public function siteAccountsVoucherChequeRegisterRecords()
    {
        return $this->hasOne(SiteAccountsVoucherChequeRegisterRecords::class,'site_account_id');
    }
}
