<?php

namespace App\Models\Site\Accounts;

use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class Bank extends SiteGlobalModel
{

    public $timestamps = true;
    protected $table='site_accounts_banks';

    const NAME = 'name';
    const ACCOUNT_TYPE = 'account_type';
    const BRANCH = 'branch';
    const MAIL = 'mail';
    const CONTACT_NO = 'contact_no';
    const ADDRESS = 'address';
    const CREATED_BY = 'created_by';
    const CREATED_DATE = 'created_date';
    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const STATUS = 'status';




    protected $fillable = [
        self::NAME,
        self::ACCOUNT_TYPE,
        self::BRANCH,
        self::MAIL,
        self::CONTACT_NO,
        self::ADDRESS,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS,

    ];

    public $ownFields = [
        self::NAME,
        self::ACCOUNT_TYPE,
        self::BRANCH,
        self::MAIL,
        self::CONTACT_NO,
        self::ADDRESS,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS,

    ];

    public function bankAccountDetails()
    {
        return $this->hasMany(BankAccountDetails::class);
    }
}
