<?php

namespace App\Models\Site\Accounts;

use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class ChequeRegister extends SiteGlobalModel
{
    public $timestamps = true;
    protected $table='site_accounts_cheque_registers';

    const SITE_ACCOUNTS_BANK_DETAIL_ID = 'site_accounts_bank_account_detail_id';
    const CHEQUE_SERIAL_NO = 'cheque_serial_no';
    const CHEQUE_NUMBER = 'cheque_number';
    const CHEQUE_ISSUE_DATE = 'cheque_issue_date';
    const CHEQUE_AMOUNT = 'cheque_amount';
    const CHEQUE_STATUS = 'cheque_status';
    const CREATED_BY = 'created_by';
    const CREATED_DATE = 'created_date';
    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const STATUS = 'status';


    protected $fillable = [
        self::SITE_ACCOUNTS_BANK_DETAIL_ID,
        self::CHEQUE_SERIAL_NO,
        self::CHEQUE_NUMBER,
        self::CHEQUE_ISSUE_DATE,
        self::CHEQUE_AMOUNT,
        self::CHEQUE_STATUS,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS,
    ];

    public $ownFields = [
        self::SITE_ACCOUNTS_BANK_DETAIL_ID,
        self::CHEQUE_SERIAL_NO,
        self::CHEQUE_NUMBER,
        self::CHEQUE_ISSUE_DATE,
        self::CHEQUE_AMOUNT,
        self::CHEQUE_STATUS,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS,
    ];

    public function bankAccountDetails()
    {
        return $this->belongsTo(BankAccountDetails::class, 'site_accounts_bank_account_detail_id');
    }

    public function siteAccountsVoucherChequeRegisterRecords()
    {
        return $this->hasOne(SiteAccountsVoucherChequeRegisterRecords::class);
    }

}
