<?php

namespace App\Models\Site\Assessment;

use App\Models\Assessment\Assessment;
use Illuminate\Database\Eloquent\Model;
use App\Models\SiteGlobalModel;

class SiteAssessmentTypeAndTypeNoSetting extends SiteGlobalModel
{
    protected $table='site_assessment_type_and_type_no_settings';

    protected $appends = array('assessment_name');

    const Academic_group_id = 'academic_group_id';
    const Site_id = 'site_id';

    const Academic_year_id = 'academic_year_id';
    const Academic_class_id = 'academic_class_id';
    const Academic_department_id = 'academic_department_id';

    const Assessment_id = 'assessment_id';
    const Assessment_type_id = 'assessment_type_id';
    const Assessment_type_no_id = 'assessment_type_no_id';
    const Position_show = 'position_show';
    const Type_access_owner = 'type_access_owner';
    const Status = 'status';

    protected $fillable = [
        self::Academic_group_id,
        self::Site_id,

        self::Academic_year_id,
        self::Academic_class_id,
        self::Academic_department_id,

        self::Assessment_id,
        self::Assessment_type_id,
        self::Assessment_type_no_id,
        self::Position_show,
        self::Type_access_owner,
        self::Status,

    ];

    public function assessment()
    {
        return $this->belongsTo(Assessment::class);

    }

    public function getAssessmentNameAttribute()
    {
        return  $this->attributes['assessment_name']= $this->assessment->assessment_name;

    }


}
