<?php

namespace App\Models\Site\Employee;

use App\Models\Academic\AcademicDepartment;
use App\Models\BloodGroup\BloodGroup;
use App\Models\Country\Country;
use App\Models\Designation\Designation;
use App\Models\District\District;
use App\Models\Division\Division;
use App\Models\Employee\SiteEmployeeDepartmentClassSubject;
use App\Models\Gender\Gender;
use App\Models\Image\Photo;
use App\Models\Site\Payroll\SiteAllowance;
use App\Models\Site\Payroll\SiteBaseSalary;
use App\Models\Site\Payroll\SiteBonus;
use App\Models\Site\Payroll\SiteDeduction;
use App\Models\Site\Payroll\SiteEmployeeAttendance;
use App\Models\Site\Payroll\SiteEmployeePayroll;
use App\Models\Religion\Religion;
use App\Models\Role\HasRoles;
use App\Models\Site\Role\SiteRole;
use App\Models\Site\Routine\EmployeeWeeklyClass;
use App\Models\Site\Routine\SiteEmployeeWeeklyClass;
use App\Models\Site\SiteInfo;
use App\Models\Site\Web\Message\Message;
use App\Models\Thana\Thana;
use App\Models\User\EmployeeHistory;
use Dimsav\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Employee extends Model
{
    use Translatable, HasRoles, SoftDeletes;
    public $translationModel = 'App\Models\User\UserTranslation';
    public $translationForeignKey = 'user_id';
    public $timestamps = true;

    protected $formName;
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'users';
    protected $dates = ['deleted_at'];

    protected $appends = array('full_name', 'weekly_class');


    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    const ALIAS = 'alias';


    public function __construct(array $attributes = [])
    {
        $this->{self::ALIAS} = session()->get('ALIAS1');
        $this->fillable[] = self::ALIAS;
        parent::__construct($attributes);

    }

    /*    public function getRelationKey()
        {
            if ($this->translationForeignKey) {
                $key = $this->translationForeignKey;
            } elseif ($this->primaryKey !== 'user_id') {
                $key = $this->primaryKey;
            } else {
                $key = $this->getForeignKey();
            }

            return $key;
        }*/

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    public function newQuery()
    {

        $alias = session()->get('ALIAS1');
        $builder = $this->newQueryWithoutScopes();
        $tableName = $builder->getModel()->getTable();
        $final = $builder->where($tableName . '.alias', $alias)
            ->where($tableName . '.deleted_at', '=', null)
            ->where($tableName . '.user_type', '=', 'employee');
        return $final;
    }


    public function setPasswordAttribute($request)
    {
        $this->attributes['password'] = bcrypt($request);

    }

    public function getFullNameAttribute()
    {
        return $this->attributes['full_name'] = ($this->first_name ?? '') . ' ' . ($this->last_name ?? '');

    }


    const Employee_Index_Number = 'employee_index_number';
    const EMPLOYEE_ID = 'employee_id';
    const SIGNATURE = 'signature';
    const INSTITUTE_HEAD = 'institute_head';
    const EMPLOYEE_SERIAL = 'employee_serial';
    const WEEKLY_CLASS = 'no_of_weekly_class';
    const USERNAME = 'username';
    const EMAIL = 'email';
    const FIRST_NAME = 'first_name';
    const LAST_NAME = 'last_name';
    const FATHER_NAME = 'father_name';
    const MOTHER_NAME = 'mother_name';
    const SPOUSE_NAME = 'spouse_name';
    const PASSWORD = 'password';
    const LAST_LOGIN = 'last_login';
    const NAME_NATIVE_LANGUAGE = 'name_native_language';
    const CONTACT_NUMBER = 'contact_number';
    const BLOOD_GROUP_ID = 'blood_group_id';
    const PARENT_OCCUPATION_ID = 'parent_occupation_id';
    const PARENT_YEARLY_INCOME = 'parent_yearly_income';
    const PARENT_CONTACT_NUMBER = 'parent_contact_number';
    const PARENT_EMAIL = 'parent_email';
    const PRESENT_COUNTRY_ID = 'present_country_id';
    const PRESENT_DIVISION_ID = 'present_division_id';
    const PRESENT_DISTRICT_ID = 'present_district_id';
    const PRESENT_THANA_ID = 'present_thana_id';
    const ADDRESS = 'address';
    const PERMANENT_COUNTRY_ID = 'permanent_country_id';
    const PERMANENT_DIVISION_ID = 'permanent_division_id';
    const PERMANENT_DISTRICT_ID = 'permanent_district_id';
    const PERMANENT_THANA_ID = 'permanent_thana_id';
    const PERMANENT_ADDRESS = 'permanent_address';
    const GENDER_ID = 'gender_id';
    const RELIGION_ID = 'religion_id';

    const GUARDIAN_STUDENT_RELATION_ID = 'guardian_student_relation_id';
    const ACADEMIC_CLASS_ID = 'academic_class_id';
    const ACADEMIC_DEPARTMENT_ID = 'academic_department_id';
    const ACADEMIC_SECTION_ID = 'academic_section_id';
    const ACADEMIC_CLASS_GROUP_ID = 'academic_class_group_id';
    const PROFESSION = 'profession';
    const LOCAL_GUARDIAN_USER_ID = 'local_guardian_user_id';
    const DEPARTMENT_ID = 'department_id';
    const DESIGNATION_ID = 'designation_id';
    const EMP_CATEGORY_ID = 'emp_category_id';
    const EMP_POSITION_ID = 'emp_position_id';
    const ACADEMIC_SHIFT_ID = 'academic_shift_id';
    const BIOMETRIC_ID = 'biometric_id';
    const DEPT_JOIN_DATE = 'dept_join_date';
    const PHONE = 'phone';
    const EMERGENCY_CONTACT = 'emergency_contact';
    const NID_NUMBER = 'nid_number';
    const PASSPORT_NO = 'passport_no';
    const BIRTH_CERTIFICATE_NO = 'birth_certificate_no';
    const STATUS = 'status';
    const REMEMBER_TOKEN = 'remember_token';
    const DATE_OF_BIRTH = 'date_of_birth';
    const DELETED_AT = 'deleted_at';
    const USER = 'site_id';

    const NATIONALITY = 'nationality';
    const INSTITUTE_JOINING_DATE = 'institute_joining_date';
    const NTRC_REGISRATION_NUMBER = 'ntrc_registration_number';
    const EMPLOYEE_ACADEMIC_SUBJECT_ID = 'employee_academic_subject_id';


    public $translatedAttributes = [
        self::FIRST_NAME,
        self::LAST_NAME,
        self::ADDRESS,
        self::SPOUSE_NAME,
        self::MOTHER_NAME,
        self::FATHER_NAME,
        self::PERMANENT_ADDRESS
    ];

    protected $fillable = [
        self::FIRST_NAME,
        self::LAST_NAME,
        self::FATHER_NAME,
        self::MOTHER_NAME,
        self::SPOUSE_NAME,
        self::Employee_Index_Number,
        self::EMPLOYEE_ID,
        self::SIGNATURE,
        self::INSTITUTE_HEAD,
        self::EMPLOYEE_SERIAL,
        self::WEEKLY_CLASS,
        self::USERNAME,
        self::EMAIL,
        self::PASSWORD,
        self::LAST_LOGIN,
        self::NAME_NATIVE_LANGUAGE,
        self::CONTACT_NUMBER,
        self::BLOOD_GROUP_ID,
        self::PARENT_OCCUPATION_ID,
        self::PARENT_YEARLY_INCOME,
        self::PARENT_CONTACT_NUMBER,
        self::PARENT_EMAIL,
        self::PRESENT_COUNTRY_ID,
        self::PRESENT_DIVISION_ID,
        self::PRESENT_DISTRICT_ID,
        self::PRESENT_THANA_ID,
        self::ADDRESS,
        self::PERMANENT_COUNTRY_ID,
        self::PERMANENT_DIVISION_ID,
        self::PERMANENT_DISTRICT_ID,
        self::PERMANENT_THANA_ID,
        self::PERMANENT_ADDRESS,
        self::GENDER_ID,
        self::RELIGION_ID,
        self::GUARDIAN_STUDENT_RELATION_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_SECTION_ID,
        self::ACADEMIC_CLASS_GROUP_ID,
        self::PROFESSION,
        self::LOCAL_GUARDIAN_USER_ID,
        self::DEPARTMENT_ID,
        self::DESIGNATION_ID,
        self::EMP_CATEGORY_ID,
        self::EMP_POSITION_ID,
        self::ACADEMIC_SHIFT_ID,
        self::BIOMETRIC_ID,
        self::DEPT_JOIN_DATE,
        self::PHONE,
        self::EMERGENCY_CONTACT,
        self::NID_NUMBER,
        self::PASSPORT_NO,
        self::BIRTH_CERTIFICATE_NO,
        self::STATUS,
        self::REMEMBER_TOKEN,
        self::DATE_OF_BIRTH,
        self::ALIAS,
        self::DELETED_AT,
//        self::SITE_ID,
        self::NATIONALITY,
        self::INSTITUTE_JOINING_DATE,
        self::NTRC_REGISRATION_NUMBER,
        self::EMPLOYEE_ACADEMIC_SUBJECT_ID,

    ];

    public $ownFields = [

        self::FIRST_NAME,
        self::LAST_NAME,
        self::FATHER_NAME,
        self::MOTHER_NAME,
        self::SPOUSE_NAME,
        self::EMPLOYEE_ID,
        self::Employee_Index_Number,
        self::SIGNATURE,
        self::INSTITUTE_HEAD,
        self::EMPLOYEE_SERIAL,
        self::USERNAME,
        self::EMAIL,
        self::PASSWORD,
        self::LAST_LOGIN,
        self::NAME_NATIVE_LANGUAGE,
        self::CONTACT_NUMBER,
        self::BLOOD_GROUP_ID,
        self::PARENT_OCCUPATION_ID,
        self::PARENT_YEARLY_INCOME,
        self::PARENT_CONTACT_NUMBER,
        self::PARENT_EMAIL,
        self::PRESENT_COUNTRY_ID,
        self::PRESENT_DIVISION_ID,
        self::PRESENT_DISTRICT_ID,
        self::PRESENT_THANA_ID,
        self::ADDRESS,
        self::PERMANENT_COUNTRY_ID,
        self::PERMANENT_DIVISION_ID,
        self::PERMANENT_DISTRICT_ID,
        self::PERMANENT_THANA_ID,
        self::PERMANENT_ADDRESS,
        self::GENDER_ID,
        self::RELIGION_ID,
        self::GUARDIAN_STUDENT_RELATION_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_SECTION_ID,
        self::ACADEMIC_CLASS_GROUP_ID,
        self::PROFESSION,
        self::LOCAL_GUARDIAN_USER_ID,
        self::DEPARTMENT_ID,
        self::DESIGNATION_ID,
        self::EMP_CATEGORY_ID,
        self::EMP_POSITION_ID,
        self::ACADEMIC_SHIFT_ID,
        self::BIOMETRIC_ID,
        self::DEPT_JOIN_DATE,
        self::PHONE,
        self::EMERGENCY_CONTACT,
        self::NID_NUMBER,
        self::PASSPORT_NO,
        self::BIRTH_CERTIFICATE_NO,
        self::STATUS,
        self::REMEMBER_TOKEN,
        self::DATE_OF_BIRTH,
        self::ALIAS,
        self::DELETED_AT,
//        self::SITE_ID,
        self::NATIONALITY,
        self::INSTITUTE_JOINING_DATE,
        self::NTRC_REGISRATION_NUMBER,
        self::EMPLOYEE_ACADEMIC_SUBJECT_ID,

    ];

    /**
     * this function is used for getting the values from
     * tables associated with hasMany relationship with the user table
     * while displaying the user-edit page
     * @var array
     */
    public $hasManyFunctions = [

//        'bankAccounts' => [
//            self::ACCOUNT_NO,
//            self::BANK,
//            self::IFSC,
//            self::PAN,
//            self::BRANCH,
//        ],
//        'userSalaries' => [
//            self::BASIC,
//            self::ALLOWANCE,
//            self::OVERTIME,
//            self::SALARY_CUT,
//            self::BONUS
//        ],
    ];

    public $belongsToFunctions = [
        'shift' => 'shift_id',
    ];


    public $saveFields = [
        self::WEEKLY_CLASS,
    ];

    public $employeeHistoryFields = [
        self::DEPARTMENT_ID,
        self::EMP_CATEGORY_ID,
        self::EMP_POSITION_ID,
        self::BIOMETRIC_ID,
        self::DEPT_JOIN_DATE,
        self::ACADEMIC_SHIFT_ID,
//        self::SITE_ID,

    ];
    public $teachersHistoryFields = [
        self::DEPARTMENT_ID,
        self::NID_NUMBER,
        self::BIOMETRIC_ID,
        self::DEPT_JOIN_DATE,
        self::ACADEMIC_SHIFT_ID,
//        self::SITE_ID,
    ];
    public $bankAccountFields = [
//        self::ACCOUNT_NO,
//        self::BANK_ACCOUNT,
//        self::BANK,
//        self::IFSC,
//        self::PAN,
//        self::BRANCH,
//        self::STATUS,
//        self::POSITION
    ];

    public $userSalaryFields = [
//        self::BASIC,
//        self::ALLOWANCE,
//        self::OVERTIME,
//        self::SALARY_CUT,
//        self::BONUS

    ];
    public $passwords = [
        self::PASSWORD
    ];
    public $emails = [
        self::EMAIL
    ];


//mutator

    public function getEmployeeIdAttribute($value)
    {
       return $value ?? $this->username;
    }

    public function setDateOfBirthAttribute($value)
    {
        $middle = strtotime($value);
        $new_date = date('Y-m-d', $middle);
        $this->attributes['date_of_birth'] = $new_date;
    }

    public function getWeeklyClassAttribute()
    {

        return $this->empWeeklyClass->weekly_class ?? 0;
    }

    public function empWeeklyClass()
    {
        return $this->hasOne(EmployeeWeeklyClass::class,'user_id');
    }

    public function employeeWeeklyClass()
    {
        return $this->hasOne(EmployeeWeeklyClass::class, 'user_id');
    }

    public function empWeeklyClasses()
    {
        return $this->hasOne(SiteEmployeeWeeklyClass::class,'user_id');
    }

    public function siteRoles()
    {
        return $this->belongsToMany(SiteRole::class, 'site_role_user', 'user_id', 'role_id');
    }


    public function activeHistory()
    {
        return $this->hasOne(EmployeeHistory::class, 'user_id')->where('status', true);
    }
    public function empHistories()
    {
        return $this->hasOne(EmployeeHistory::class, 'user_id');
    }


// payroll
    public function payrolls()
    {
        return $this->hasMany(SiteEmployeePayroll::class,'user_id');
    }
    public function BaseSalery()
    {
        return $this->hasOne(SiteBaseSalary::class,'user_id');
    }
    public function Allowances()
    {
        return $this->hasMany(SiteAllowance::class,'user_id');
    }
    public function EmployeeAttendance()
    {
        return $this->hasMany(SiteEmployeeAttendance::class,'user_id');
    }
    public function Bonus()
    {
        return $this->hasMany(SiteBonus::class,'user_id');
    }
    public function Deductions()
    {
        return $this->hasMany(SiteDeduction::class,'user_id');
    }

    public function religion()
    {
        return $this->belongsTo(Religion::class);
    }


    /**
     * @return \Illuminate\Database\Eloquent\Relations\MorphMany
     */
    public function photo()
    {
        return $this->morphMany(Photo::class, 'imageable');
    }

    public function photos()
    {
        return $this->morphMany(Photo::class, 'imageable');

       // return $this->hasMany(Photo::class, 'imageable_id');
    }


    public function designation()
    {
        return $this->belongsTo(Designation::class);
    }

    public function attendance()
    {
        return $this->hasOne(EmployeeAttendance::class, 'user_id');
    }

    public function attendances()
    {
        return $this->hasMany(EmployeeAttendance::class, 'user_id');
    }

    public function latestPhoto()
    {
        return $this->morphOne(Photo::class, 'imageable')->orderBy('id', 'DESC');
      /*  return $this->hasOne(Photo::class, 'imageable_id')
            ->where('imageable_type','App\Models\Site\Employee\Employee')
            ->orderBy('id', 'DESC');*/
    }


    public function site()
    {
        return $this->belongsTo(SiteInfo::class,'site_id');
    }

    public function department()
    {
        return $this->belongsTo(AcademicDepartment::class);
    }


    public function empShifts()
    {
        //  return $this->belongsToMany(Emp::class, 'edu_role_user', 'user_id', 'role_id');
        return $this->hasMany(SiteEmployeeSiteShift::class, 'user_id');
    }
    public function EmployeeDepartmentClassSubject()
    {
        return $this->hasMany(SiteEmployeeDepartmentClassSubject::class, 'user_id');
    }


    /**
     * more than one user should belong to a gender
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function gender()
    {
        return $this->belongsTo(Gender::class);
    }


    public function presentCountry()
    {
        return $this->belongsTo(Country::class, 'present_country_id');
    }

    public function permanentCountry()
    {
        return $this->belongsTo(Country::class, 'permanent_country_id');
    }

    public function presentDivision()
    {
        return $this->belongsTo(Division::class, 'present_division_id');
    }

    public function permanentDivision()
    {
        return $this->belongsTo(Division::class, 'permanent_division_id');
    }

    public function presentDistrict()
    {
        return $this->belongsTo(District::class, 'present_district_id');
    }

    public function permanentDistrict()
    {
        return $this->belongsTo(District::class, 'permanent_district_id');
    }

    public function presentThana()
    {
        return $this->belongsTo(Thana::class, 'present_thana_id');
    }

    public function permanentThana()
    {
        return $this->belongsTo(Thana::class, 'permanent_thana_id');
    }


    public function bloodGroup()
    {
        return $this->belongsTo(BloodGroup::class,'blood_group_id');
    }


    public function siteInfoes()
    {
        return $this->belongsToMany(SiteInfo::class, 'site_info_user', 'user_id', 'site_id');
    }

    public function siteInfo()
    {
        return $this->belongsTo(SiteInfo::class, 'site_id');
    }

}
