<?php

namespace App\Models\Site\EmployeeDuty;

use App\Models\Academic\AcademicDutyType;
use App\Models\SiteGlobalModel;
use App\Models\User\EmployeeHistory;
use Illuminate\Database\Eloquent\Model;

class SiteEmployeeDutyHistory extends SiteGlobalModel
{
    public $timestamps = true;
    protected $table='site_employee_duty_histories';

    const Employee_history_id = 'employee_history_id';
    const Academic_duty_type_id = 'academic_duty_type_id';
    const Request_date = 'request_date';
    const From_date = 'from_date';
    const To_date = 'to_date';
    const Reason = 'reason';
    const Status = 'status';
    const Duty_status = 'duty_status';
    const Assign_site_id = 'assign_site_id';
    const User_id = 'user_id';
    const Site_id = 'site_id';
    const Academic_group_id = 'academic_group_id';


    protected $fillable = [
        self::Employee_history_id,
        self::Academic_duty_type_id,
        self::Request_date,
        self::From_date,
        self::To_date,
        self::Reason,
        self::Duty_status,
        self::Assign_site_id,
        self::Status,
        self::User_id,
        self::Site_id,
        self::Academic_group_id,
    ];



    public function academicDutyType(){

       return $this->belongsTo(AcademicDutyType::class,'academic_duty_type_id');

    }

    public function employeeHistory(){

       return $this->belongsTo(EmployeeHistory::class,'employee_history_id');

    }

    public function user(){

       return $this->belongsTo(EmployeeHistory::class,'user_id');

    }



}
