<?php

namespace App\Models\Site\EmployeeLeave;

use App\Models\Academic\AcademicFiscalYear;
use App\Models\SiteGlobalModel;
use App\Models\Status\Status;
use App\Models\User\EmployeeHistory;
use App\Models\User\GlobalEmployeeHistory;
use Illuminate\Database\Eloquent\Model;

class GlobalSiteEmployeeLeaveHistory extends Model
{

    public $timestamps = true;
    protected $table='site_employee_leave_histories';

    const Site_employee_leave_generate_id = 'site_employee_leave_generate_id';
    const Employee_history_id = 'employee_history_id';
    const Spend_leave_days = 'spend_leave_days';
    const Remaining_days = 'remaining_days';
    const From_date = 'from_date';
    const To_date = 'to_date';

    const Reason = 'reason';
    const Approved_or_cancelled_by = 'approved_or_cancelled_by';
    const Request_date = 'request_date';
    const Approve_date = 'approve_date';
    const Cancel_date = 'cancel_date';
    const Leave_status = 'leave_status';
    const Approve_status = 'approve_status';

    const STATUS = 'status';


    protected $fillable = [
        self::Site_employee_leave_generate_id,
        self::Employee_history_id,
        self::Spend_leave_days,
        self::Remaining_days,
        self::From_date,
        self::To_date,
        self::Reason,
        self::Approved_or_cancelled_by,
        self::Request_date,
        self::Approve_date,
        self::Cancel_date,
        self::Leave_status,
        self::Approve_status,
        self::STATUS
    ];

    public $ownFields = [
        self::Site_employee_leave_generate_id,
        self::Employee_history_id,
        self::Spend_leave_days,
        self::Remaining_days,
        self::From_date,
        self::To_date,
        self::Reason,
        self::Approved_or_cancelled_by,
        self::Request_date,
        self::Approve_date,
        self::Cancel_date,
        self::Leave_status,
        self::Approve_status,
        self::STATUS

    ];

    public function siteLeavePolicy()
    {
        return $this->belongsTo(GlobalSiteLeavePolicy::class,'site_leave_policy_id');
    }

    public function employeeHistory()
    {
        return $this->belongsTo(GlobalEmployeeHistory::class);
    }

    public function academicFiscalYear()
    {
        return $this->belongsTo(AcademicFiscalYear::class);
    }

    public function siteEmployeeLeaveGenerate()
    {
        return $this->belongsTo(GlobalSiteEmployeeLeaveGenerate::class,'site_employee_leave_generate_id');
    }

    public function status()
    {
        return $this->belongsTo(Status::class);
    }

}
