<?php

namespace App\Models\Site\Event;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GlobalEvent extends Model
{
    use SoftDeletes;

    public $timestamps = true;

    protected $table = 'events';

    protected $dates = ['deleted_at'];

    const ACTIVATE_DATE = 'activate_date';
    const START_DATE = 'start_date';
    const END_DATE = 'end_date';
    const IDENTIFICATION_NUMBER = 'identification_number';
    const TITLE = 'title';
    const DESCRIPTION = 'description';
    const ACADEMIC_CALENDAR_HEAD_ID = 'academic_calendar_head_id';
    const SUBHEAD_COLOR_ID = 'subhead_color_id';
    const EVENT_VENUE = 'event_venue';
    const EVENT_TYPE = 'event_type';
    const DAY_NAME = 'day_name';
    const ATTENDANCE_ACTIVE_FOR_STUDENT = 'attendance_active_for_student';
    const ATTEMDANCE_ACTIVE_EMPLOYEE = 'attendance_active_for_employee';
    const YEAR = 'year';
    const MONTH = 'month';
    const STATUS = 'status';
//    const PHOTO = 'photo';



    protected $fillable = [
        self::ACTIVATE_DATE,
        self::START_DATE,
        self::END_DATE,
        self::IDENTIFICATION_NUMBER,
        self::TITLE,
        self::DESCRIPTION,
        self::TITLE,
        self::ACADEMIC_CALENDAR_HEAD_ID,
        self::SUBHEAD_COLOR_ID,
        self::DAY_NAME,
        self::ATTENDANCE_ACTIVE_FOR_STUDENT,
        self::ATTEMDANCE_ACTIVE_EMPLOYEE,
        self::YEAR,
        self::MONTH,
        self::STATUS,
        self::EVENT_TYPE,

    ];

    public $ownFields = [
        self::ACTIVATE_DATE,
        self::START_DATE,
        self::END_DATE,
        self::IDENTIFICATION_NUMBER,
        self::EVENT_TYPE,
        self::ACADEMIC_CALENDAR_HEAD_ID,
        self::SUBHEAD_COLOR_ID,
        self::TITLE,
        self::DESCRIPTION,
        self::DAY_NAME,
        self::ATTENDANCE_ACTIVE_FOR_STUDENT,
        self::ATTEMDANCE_ACTIVE_EMPLOYEE,
        self::YEAR,
        self::MONTH,
        self::STATUS

    ];

}
