<?php

namespace App\Models\Site\Exam\Question;

use App\Models\ProjectModel;
use App\Models\Site\Exam\SiteExamQuestion;
use App\Models\Site\Exam\SiteExamQuestionDetails;
use Illuminate\Database\Eloquent\Model;

class SiteExamStudentQuestion extends ProjectModel
{
    protected $table='site_exam_student_questions';


    const Site_exam_declare_id = 'site_exam_declare_id';
    const Site_exam_question_declare_id = 'site_exam_question_declare_id';
    const Student_history_id = 'student_history_id';
    const Site_exam_declare_student_subject_id = 'site_exam_declare_student_subject_id';
    const Site_exam_question_id = 'site_exam_question_id';
    const Site_exam_question_detail_ids = 'site_exam_question_detail_ids';
    const Answer_ids = 'answer_ids';
    const Student_answer_ids = 'student_answer_ids';
    const Site_id = 'site_id';
    const Status = 'status';



    protected $fillable = [
        self::Site_exam_declare_id,
        self::Site_exam_question_declare_id,
        self::Student_history_id,
        self::Site_exam_declare_student_subject_id,
        self::Site_exam_question_id,
        self::Site_id,
        self::Site_exam_question_detail_ids,
        self::Answer_ids,
        self::Status,

    ];

    protected $ownFields = [
        self::Site_exam_declare_id,
        self::Site_exam_question_declare_id,
        self::Student_history_id,
        self::Site_exam_declare_student_subject_id,
        self::Site_exam_question_id,
        self::Site_id,
        self::Site_exam_question_detail_ids,
        self::Answer_ids,
        self::Status,
    ];


    public function siteExamQuestion()
    {
        return $this->belongsTo(SiteExamQuestion::class);
    }


    public function getSiteExamQuestionDetailIdsAttribute($values)
    {
        $ids=array_map('intval', explode(',', $values));

        $placeholders = implode(',',array_fill(0, count($ids), '?'));

        $array_value= $this->attributes['site_exam_question_detail_ids'] = SiteExamQuestionDetails::whereIn('id', $ids)
            ->orderByRaw("field(id,{$placeholders})", $ids)
            ->get();

        return [$ids, $array_value];
    }



}
