<?php

namespace App\Models\Site\ExamCommittee;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteExamCommitteeSetting extends SiteGlobalModel
{
    protected $table='site_exam_committee_settings';


    const Committee_name = 'committee_name';
    const Duration_from_date = 'duration_from_date';
    const Duration_to_date = 'duration_to_date';
    const Extended_date = 'extended_date';
    const Status = 'status';


    const Academic_shift_ids = 'academic_shift_ids';
    const Academic_version_ids = 'academic_version_ids';
    const Academic_year_ids = 'academic_year_ids';
    const Academic_department_ids = 'academic_department_ids';
    const Academic_class_ids = 'academic_class_ids';



    public function getAcademicShiftIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicShift::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }
    public function getAcademicVersionIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicVersion::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }
    public function getAcademicYearIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicYear::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }
    public function getAcademicDepartmentIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicDepartment::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }
    public function getAcademicClassIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicClass::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }


    protected $fillable = [
        self::Committee_name,
        self::Duration_from_date,
        self::Duration_to_date,
        self::Extended_date,
        self::Status,

        self::Academic_shift_ids,
        self::Academic_version_ids,
        self::Academic_year_ids,
        self::Academic_department_ids,
        self::Academic_class_ids,

    ];

    protected $ownFields = [
        self::Committee_name,
        self::Duration_from_date,
        self::Duration_to_date,
        self::Extended_date,
        self::Status,
        self::Academic_shift_ids,
        self::Academic_version_ids,
        self::Academic_year_ids,
        self::Academic_department_ids,
        self::Academic_class_ids,

    ];


    public function siteExamCommitteeEmployee()
    {
        return $this->hasMany(SiteExamCommitteeEmployeeSetting::class);
    }



}
