<?php

namespace App\Models\Site\Fee;

use App\Models\Academic\AcademicFeeGroup;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicFeeSubHead;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteStudentFeeFineAllocation extends SiteGlobalModel
{
    public $timestamps = false;
    protected $table='site_student_fee_fine_allocations';

    const ACADEMIC_FEE_HEAD_ID = 'academic_fee_head_id';
    const ACADEMIC_FEE_SUB_HEAD_ID = 'academic_fee_sub_head_id';
    const ACADEMIC_FEE_GROUP_ID = 'academic_fee_group_id';
    const ACADEMIC_VERSION_ID = 'academic_version_id';
    const ACADEMIC_SHIFT_ID = 'academic_shift_id';
    const ACADEMIC_SESSION_ID = 'academic_session_id';
    const ACADEMIC_DEPARTMENT_ID = 'academic_department_id';
    const ACADEMIC_CLASS_ID = 'academic_class_id';
    const ACADEMIC_SECTION_ID = 'academic_section_id';
    const ACADEMIC_CLASS_GROUP_ID = 'academic_class_group_id';
    const ACADEMIC_SUBJECT_ID = 'academic_subject_id';
    const ACADEMIC_YEAR_ID = 'academic_year_id';
    const AMOUNT = 'amount';
    const FINE_AMOUNT = 'fine_amount';
    const FINE_APPLICABLE_DATE = 'fine_applicable_date';
    const FINE_APPLICABLE_DAY = 'fine_applicable_day';
    const SITE_GROUP_ID = 'site_group_id';
    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const STATUS = 'status';


    protected $fillable = [
        self::ACADEMIC_FEE_HEAD_ID,
        self::ACADEMIC_FEE_SUB_HEAD_ID,
        self::ACADEMIC_FEE_GROUP_ID,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_SESSION_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_SECTION_ID,
        self::ACADEMIC_CLASS_GROUP_ID,
        self::ACADEMIC_SUBJECT_ID,
        self::ACADEMIC_YEAR_ID,
        self::AMOUNT,
        self::FINE_AMOUNT,
        self::FINE_APPLICABLE_DATE,
        self::FINE_APPLICABLE_DAY,
        self::SITE_GROUP_ID,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS,

    ];

    public $ownFields = [
        self::ACADEMIC_FEE_HEAD_ID,
        self::ACADEMIC_FEE_SUB_HEAD_ID,
        self::ACADEMIC_FEE_GROUP_ID,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_SESSION_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_SECTION_ID,
        self::ACADEMIC_CLASS_GROUP_ID,
        self::ACADEMIC_SUBJECT_ID,
        self::ACADEMIC_YEAR_ID,
        self::AMOUNT,
        self::FINE_AMOUNT,
        self::FINE_APPLICABLE_DATE,
        self::FINE_APPLICABLE_DAY,
        self::SITE_GROUP_ID,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS,
    ];

    public function academicFeeHead()
    {
        return $this->belongsTo(AcademicFeeHead::class);
    }


    public function academicFeeGroup()
    {
        return $this->belongsTo(AcademicFeeGroup::class);
    }

    public function academicFeeSubHead()
    {
        return $this->belongsTo(AcademicFeeSubHead::class);
    }


}