<?php

namespace App\Models\Site\Fee;

use App\Models\Site\Payment\PaymentGateway;
use App\Models\Site\Payment\SitePaymentGateway;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteStudentFeeGatewaySetting extends SiteGlobalModel
{
    public $timestamps = true;
    protected $table='site_student_fee_gateway_settings';

    const Site_id = 'site_id';
    const Academic_group_id = 'academic_group_id';
    const Academic_payment_method_key = 'academic_payment_method_key';
    const Payment_geteway_id = 'site_payment_gateway_id';
    const Fee_type_key = 'fee_type_key';
    const IID = 'IID';
    const Academic_fee_head_id = 'academic_fee_head_id';
    const Academic_fee_sub_head_id = 'academic_fee_sub_head_id';
    const Fine_amount_push_status = 'fine_amount_push_status';
    const Fee_percentage = 'fee_percentage';
    const Created_by = 'created_by';
    const Updated_by = 'updated_by';
    const Status = 'status';

    protected $fillable = [
        self::Site_id,
        self::Academic_group_id,
        self::Academic_payment_method_key,
        self::Payment_geteway_id,
        self::Fee_type_key,
        self::IID,
        self::Academic_fee_head_id,
        self::Academic_fee_sub_head_id,
        self::Fine_amount_push_status,
        self::Fee_percentage,
        self::Created_by,
        self::Updated_by,
        self::Status,
    ];

  

    public function paymentGateway()
    {
        return $this->belongsTo(SitePaymentGateway::class,'site_payment_gateway_id');
    }
}
