<?php

namespace App\Models\Site\Guardian;

use App\Models\Role\HasRoles;
use Dimsav\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Guardian extends Model
{
 //   use Translatable, HasRoles, SoftDeletes;


    public $translationModel = 'App\Models\User\UserTranslation';
    public $translationForeignKey = 'user_id';
    public $timestamps = true;


    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'users';

    protected $dates = ['deleted_at'];
    protected $appends = array('full_name');

    protected $hidden = [
        'password', 'remember_token',
    ];
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */


    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    public function __construct(array $attributes = [])
    {
        $this->fillable[] = self::ALIAS;
        $this->{self::ALIAS} = session()->get('ALIAS');
        parent::__construct($attributes);
    }


    public function newQuery()
    {

        $alias = session()->get('ALIAS');
        $builder = $this->newQueryWithoutScopes();
        $tableName = $builder->getModel()->getTable();
        if ($alias) {
            $final = $builder->where($tableName . '.alias', $alias);
            return $final;//$this->applyGlobalScopes($final);
        } else {
            return $builder;
        }

    }

//    public function findForPassport($username) {
//        return self::where('username', $username)->first(); // change column name whatever you use in credentials
//    }

    const ALIAS = 'alias';


    const USER_NAME = 'username';
    const FIRST_NAME = 'first_name';
    const LAST_NAME = 'last_name';
    const FATHER = 'father_name';
    const MOTHER = 'mother_name';
    const GENDER = 'gender_id';
    const RELIGION = 'religion_id';
    const COMPANY = 'company_id';
    const DEPARTMENT = 'department_id';
    const BIOMETRIC = 'biometric_id';
    const PHONE = 'phone';
    const ADDRESS = 'address';
    const PERMANENT_ADDRESS = 'permanent_address';
    const STATUS = 'status';
    const PASSWORD = 'password';
    const EMAIL = 'email';
    const DESIGNATION = 'designation_id';
    const EMPCATEGORY = 'emp_category_id';
    const EMPPOSITION = 'emp_position_id';
    const CONFIRM_PASSWORD = 'password_confirmation';
    const DETP_JOIN_DATE = 'dept_join_date';
    const BIRTHDAY = 'birthday';
    const ACCOUNT_HOLDER = 'account_holder';
    const ACCOUNT_NO = 'account_no';
    const BANK = 'bank_name';
    const IFSC = 'ifsc_code';
    const BRANCH = 'branch';
    const PAN = 'pan_no';
    const PHOTO = 'photo';
    const SHIFT = 'shift_id';
    const BASIC = 'basic';
    const ALLOWANCE = 'salary_rule_id';
    const OVERTIME = 'overtime_rule_id';
    const SALARY_CUT = 'salary_cut_rule_id';
    const BONUS = 'bonus_rule_id';
    const EMPLOYEE_ID = 'employee_id';
    const ROLE = 'role';
    const COMPANY_DETAILS = 'company_details';
    const SALARY_DETAILS = 'salary_details';
    const AUTHENTICATION_INFO = 'authentication_info';
    const BANK_ACCOUNT = 'bank_account';
    const EMPLOYEE_DOCUMENT = 'employee_documents';
    const FILES_TO_UPLOAD = 'file[]';
    const POSITION = 'position';
    const STUDENT_CLASS = 'student_class_id';
    const SECTION = 'section_id';
    const SUBJECT_GROUP = 'subject_group_id';
    const ROLL_NO = 'roll_no';
    const PROFESSION = 'profession';
    const GUARDIAN = 'guardian_id';
    const EMERGENCY_CONTACT = 'emergency_contact';
    const NID_NUMBER = 'nid_number';
    const NATIONAL_ID = 'national_id';
    const PASSPORT_NUMBER = 'passport_no';
    const BIRTH_CERTIFICATE_NUMBER = 'birth_certificate_no';
    const NAME = 'name';
    const TYPE = 'type';
    const LOCALE = 'locale';
    const USER = 'user_id';
    const REMEMBER_TOKEN = 'remember_token';


    public $translatedAttributes = [
        self::FIRST_NAME,
        self::LAST_NAME,
        self::ADDRESS,
        self::MOTHER,
        self::FATHER,
        self::PERMANENT_ADDRESS
    ];

    protected $fillable = [

        self::USER_NAME,
        self::FIRST_NAME,
        self::LAST_NAME,
        self::GENDER,
        self::RELIGION,
        self::DEPARTMENT,
        self::BIOMETRIC,
        self::PHONE,
        self::ADDRESS,
        self::STATUS,
        self::EMAIL,
        self::PASSWORD,
        self::DESIGNATION,
        self::EMPCATEGORY,
        self::EMPPOSITION,
        self::DETP_JOIN_DATE,
        self::PERMANENT_ADDRESS,
        self::SHIFT,
        self::EMPLOYEE_ID,
        self::BONUS,
        self::GUARDIAN,
        self::NID_NUMBER,
        self::PASSPORT_NUMBER,
        self::EMERGENCY_CONTACT,
        self::BIRTH_CERTIFICATE_NUMBER
    ];

    //mutator
    public function getFullNameAttribute()
    {
        return $this->attributes['full_name'] = ($this->first_name ?? '') . ' ' . ($this->last_name ?? '');

    }

}
