<?php

namespace App\Models\Site\Permission;

use App\Models\Site\Role\GlobalSiteRole;
use Illuminate\Database\Eloquent\Model;

class GlobalSiteRoleAccess extends Model
{
    protected $table='site_role_accesses';
    public $timestamps = true;


    const SITE_ROLE_ID = 'site_role_id';
    const SUB_MODULE_IDS = 'sub_module_ids';
    const SITE_ID = 'site_id';


    protected $fillable = [
        self::SITE_ROLE_ID,
        self::SUB_MODULE_IDS,
        self::SITE_ID
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function role()
    {
        return $this->belongsTo(GlobalSiteRole::class,self::SITE_ROLE_ID);
    }
}
