<?php

namespace App\Models\Site\Result;

use App\Models\Academic\AcademicResultSystem;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteResultSystemSetting extends SiteGlobalModel
{
    public $timestamps = true;
    protected $table='site_result_system_settings';

    const Academic_year_id = 'academic_year_id';
    const Academic_version_id = 'academic_version_id';
    const Academic_shift_id = 'academic_shift_id';
    const Academic_department_id = 'academic_department_id';
    const Academic_class_id = 'academic_class_id';
    const Academic_group_id = 'academic_group_id';
    const Academic_session_id = 'academic_session_id';

    const Academic_result_system_id = 'academic_result_system_id';
    const Number_from = 'number_from';
    const Number_to = 'number_to';
    const Point = 'point';
    const Point_from = 'point_from';
    const Point_to = 'point_to';
    const Pass_fail_status = 'pass_fail_status';
    const Perfomance = 'performance';
    const Description = 'description';
    const Site_id = 'site_id';
    const Status = 'status';


    protected $fillable = [
        self::Academic_year_id,
        self::Academic_version_id,
        self::Academic_shift_id,
        self::Academic_department_id,
        self::Academic_class_id,
        self::Academic_group_id,
        self::Academic_session_id,
        self::Academic_result_system_id,
        self::Number_from,
        self::Number_to,
        self::Point,
        self::Point_from,
        self::Point_to,
        self::Pass_fail_status,
        self::Perfomance,
        self::Description,
        self::Site_id,
        self::Status,
    ];

    public $ownFields = [
        self::Academic_year_id,
        self::Academic_version_id,
        self::Academic_shift_id,
        self::Academic_department_id,
        self::Academic_class_id,
        self::Academic_group_id,
        self::Academic_session_id,
        self::Academic_result_system_id,
        self::Number_from,
        self::Number_to,
        self::Point,
        self::Point_from,
        self::Point_to,
        self::Pass_fail_status,
        self::Perfomance,
        self::Description,
        self::Site_id,
        self::Status,
    ];


    public function academicResultSystem()
    {
        return $this->belongsTo(AcademicResultSystem::class);
    }




}
