<?php

namespace App\Models\Site\Result;

use App\Models\Academic\AcademicResultCombineType;
use App\Models\ProjectModel;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Student\StudentHistory;
use Illuminate\Database\Eloquent\Model;

class SiteStudentCombineResultDetail extends ProjectModel
{

    public $timestamps = true;
    protected $table='site_student_combine_result_details';


    const STUDENT_HISTORY_ID = 'student_history_id';
    const ACADEMIC_RESULT_PRIMARY_TYPE_ID = 'academic_result_combine_type_id';
    const GPA = 'gpa';
    const GRADE = 'grade';
    const FAIL_SUBJECT_COUNT = 'fail_subject_count';
    const RESULT_DETAIL = 'result_detail';
    const Individual_primary_result_list = 'individual_primary_result_list';
    const Combine_subject_present_status = 'combine_subject_present_status';
    const TABLE_HEADER = 'table_header';
    const Highest_mark = 'highest_mark';
    const Subject_highest_mark_list = 'subject_highest_mark_list';


    const Total_marks = 'total_marks';
    const Average_total_marks = 'average_total_marks';
    const Average_marks = 'average_marks';

    const Final_point_without_optional = 'final_point_without_optional';
    const Final_grade_without_optional = 'final_grade_without_optional';
    const Combine_subject_present = 'combine_subject_present';
    const Student_rank = 'student_rank';
    const Pass_fail_status = 'pass_fail_status';


    const Result_employee_publish_status = 'result_employee_publish_status';
    const Result_student_publish_status = 'result_student_publish_status';
    const Result_public_publish_status = 'result_public_publish_status';
    const Result_public_full_publish_status = 'result_public_full_publish_status';
    
    const STATUS = 'status';


  //  sum_of_obtain_total_grade_for_show
  //  sum_of_obtain_total_point_for_show
  //  sum_of_obtain_total_marks_for_show

    protected $fillable = [
        self::STUDENT_HISTORY_ID,
        self::ACADEMIC_RESULT_PRIMARY_TYPE_ID,
        self::Final_point_without_optional,
        self::Final_grade_without_optional,
        self::Combine_subject_present,
      
        self::GPA,
        self::GRADE,
        self::FAIL_SUBJECT_COUNT,
        self::RESULT_DETAIL,
        self::Student_rank,
        self::Pass_fail_status,
        self::Individual_primary_result_list,
        self::Combine_subject_present_status,
        self::TABLE_HEADER,
        self::Highest_mark,
        self::Subject_highest_mark_list,
        self::TABLE_HEADER,
        self::STATUS,

        self::Total_marks,
        self::Average_total_marks,
        self::Average_marks,

        self::Result_employee_publish_status,
        self::Result_student_publish_status,
        self::Result_public_publish_status,
        self::Result_public_full_publish_status,
    ];

    public $ownFields = [
        self::STUDENT_HISTORY_ID,
        self::ACADEMIC_RESULT_PRIMARY_TYPE_ID,
        self::Final_point_without_optional,
        self::Final_grade_without_optional,
        self::Combine_subject_present,
      
        self::GPA,
        self::GRADE,
        self::FAIL_SUBJECT_COUNT,
        self::RESULT_DETAIL,
        self::Student_rank,
        self::Pass_fail_status,
        self::Individual_primary_result_list,
        self::Combine_subject_present_status,
        self::TABLE_HEADER,
        self::Highest_mark,
        self::Subject_highest_mark_list,
        self::STATUS,

        self::Total_marks,
        self::Average_total_marks,
        self::Average_marks,

        self::Result_employee_publish_status,
        self::Result_student_publish_status,
        self::Result_public_publish_status,
        self::Result_public_full_publish_status,
    ];

    public function getSubjectDetailAttribute($values)
    {
        return $this->attributes['subject_detail'] = json_decode($values['result_detail']);

    }
    // public function getIndividualPrimaryResultListAttribute($values)
    // {
    //     return $this->attributes['individual_primary_result_list'] = json_decode($values['individual_primary_result_list'], true);

    // }
    // public function getTableHeaderAttribute($values)
    // {
    //     return $this->attributes['table_header'] = json_decode($values['table_header'])->toArray();

    // }

    public function studentHistory()
    {
        return $this->belongsTo(StudentHistory::class,'student_history_id');
    }

    public function academicResultCombineType()
    {
        return $this->belongsTo(AcademicResultCombineType::class,'academic_result_combine_type_id');
    }



}
