<?php

namespace App\Models\Site\Role;

use App\User;
use Illuminate\Database\Eloquent\Model;

class GlobalSiteRole extends Model
{
    protected $table='site_roles';
    public $timestamps = true;


    const NAME    = 'name';
    const SITE_ID  = 'site_id';
    const STATUS  = 'status';

    protected $fillable =[
        self::NAME,
        self::SITE_ID,
        self::STATUS,

    ];


    public function users()
    {
        return $this->belongsToMany(User::class,'site_role_user', 'site_role_id', 'user_id');
    }

}
