<?php

namespace App\Models\Site\Routine;

use App\Models\Academic\AcademicSubject;
use App\Models\Room\Room;
use App\Models\Site\Employee\Employee;
use Illuminate\Database\Eloquent\Model;

class RoutineSwapCancel extends Model
{

    public $timestamps = true;
    protected $table = 'site_routine_swap_cancels';


    protected $casts=[
        'is_cancelled'=>'integer'
    ];

    const SWAP_CANCEL_DATE = 'swap_cancel_date';
    const ALLOCATION_ID = 'allocation_id';
    const SWAP_CANCEL_REASON = 'swap_cancel_reason';
    const EMPLOYEE_ID = 'employee_id';
    const ROOM_ID = 'room_id';
    const SUBJECT_ID = 'subject_id';

    protected $fillable = [
        self::SWAP_CANCEL_DATE,
        self::ALLOCATION_ID,
        self::SWAP_CANCEL_REASON,
        self::EMPLOYEE_ID,
        self::SUBJECT_ID,
        self::ROOM_ID,
    ];



    protected $ownFields = [
        self::SWAP_CANCEL_DATE,
        self::ALLOCATION_ID,
        self::SWAP_CANCEL_REASON,
        self::EMPLOYEE_ID,
        self::SUBJECT_ID,
        self::ROOM_ID,
    ];




    protected $appends = array('employee_name_ex', 'subject_name_ex', 'room_name_ex');

    public function getEmployeeNameExAttribute()
    {
        return $this->attributes['employee_name_ex'] = ($this->employee->full_name ?? 'N/A');

    }

    public function getSubjectNameExAttribute()
    {
        return $this->attributes['subject_name_ex'] = ($this->subject->subject_name ?? 'N/A');
    }

    public function getRoomNameExAttribute()
    {
        return $this->attributes['room_name_ex'] = ($this->room->building->building_name ?? '') .' '.($this->room->floor->floor_name ?? '') .'('.($this->room->room_name ?? '').')';

    }


    public function allocation()
    {
        return $this->belongsTo(RoutineAllocation::class, 'allocation_id');
    }


    public function room()
    {
        return $this->belongsTo(Room::class, 'room_id');
    }

    public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id');
    }


    public function subject()
    {
        return $this->belongsTo(AcademicSubject::class, 'subject_id');
    }
}
