<?php

namespace App\Models\Site\Routine;

use App\Models\ProjectModel;
use App\Models\Site\Employee\Employee;

class SiteEmployeeWeeklyClass extends ProjectModel
{
    protected $table = 'site_routine_employee_weekly_classes';
    public $timestamps = true;

    const WEEKLY_CLASS = 'weekly_class';
    const USER_ID = 'user_id';
    const STATUS = 'status';


    protected $fillable = [
        self::WEEKLY_CLASS,
        self::USER_ID,
        self::STATUS,

    ];


    public function employee()
    {
        return $this->belongsTo(Employee::class, 'user_id');
    }
}
