<?php

namespace App\Models\Site;


use App\Models\Academic\AcademicBoard;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicShift;
use App\Models\District\District;
use App\Models\Modules\SubModule;
use App\Models\Site\Employee\GlobalEmployee;
use App\Models\Site\Notice\Notice;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Site\Web\SiteWebSiteVisitorDetail;
// use App\Models\SiteGroup\Site\Employee\EmployeeHistory;
use App\Models\Student\StudentHistory;
use Dimsav\Translatable\Translatable;
use App\Models\Image\Photo;
use App\Models\User\EmployeeHistory;
use App\Models\User\GlobalEmployeeHistory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;

class SiteInfo extends Model//GlobalSiteInfo use the model
{
    use SoftDeletes, Translatable, Notifiable;

    public $timestamps = true;
    protected $dates = ['deleted_at'];

    protected $table = 'site_infos';

    protected $casts = [
        'site_phone' => 'string',
        'status' => 'integer',
        'emp_in_sms' => 'integer',
        'emp_out_sms' => 'integer',
        'academic_year_ids' => 'string',
    ];

    public $translatedAttributes = [
        self::SITE_NAME,
        self::SHORT_NAME,
        self::SITE_ADDRESS,
    ];

    /* public function receivesBroadcastNotificationsOn()
     {
         return 'site_infos.'.$this->id;
     }*/

    const SITE_GROUP_ID = 'site_group_id';
    const SITE_NAME = 'site_name';
    const SITE_NAME_NATIVE_LANGUAGE = 'site_name_native_language';
    const SHORT_NAME = 'short_name';
    const COUNTRY = 'country_id';
    const DIVISION = 'division_id';
    const DISTRICT = 'district_id';
    const THANA = 'thana_id';
    const SITE_ADDRESS = 'address';

    const SITE_ALIAS = 'site_alias';
    const Google_map_address = 'google_map_address';

    const SITE_EMAIL = 'site_email';
    const SITE_PHONE = 'site_phone';
    const SITE_LOGO = 'site_logo';
    const BOARD = 'board_id';
    const EIIN = 'eiin';
    const COLLEGE_CODE = 'college_code';
    const NU_CODE = 'nu_code';
    const DOMAIN_NAME = 'domain_name';
    const ACADEMIC_GROUP_IDS = 'academic_group_ids';


    const ACADEMIC_PERIOD_YPE_IDS = 'academic_period_type_ids';
    const Employee_academic_transport_ids = 'employee_academic_transport_ids';
    const Employee_academic_residence_ids = 'employee_academic_residence_ids';
    const Employee_academic_student_quata_ids = 'employee_academic_student_quata_ids';
    const Emp_grade_ids = 'emp_grade_ids';
    const Employee_examination_ids = 'employee_examination_ids';

    const ACADEMIC_FISCAL_YEAR_IDS = 'academic_fiscal_year_ids';

    const EMP_IN_SMS = 'emp_in_sms';
    const EMP_OUT_SMS = 'emp_out_sms';
    const REASON = 'reason';
    const STATUS = 'status';

    const Facebook_link = 'facebook_link';
    const Twitter_link = 'twitter_link';
    const Google_link = 'google_link';
    const Youtube_link = 'youtube_link';

    const ACADEMIC_BOARD_ID = 'academic_board_id';

    const Admit_card_description = 'admit_card_description';
    const Std_fee_paid_sms = 'std_fee_paid_sms';
    const HOUSE_IDS = 'house_ids';
    const All_admin_fee_collection_status = 'all_admin_fee_collection_status';
    const Web_student_fee_collection_status = 'web_student_fee_collection_status';
    const Student_fee_collection_status = 'student_fee_collection_status';
    const Admission_fee_collection_status = 'admission_fee_collection_status';
    const Admission_fee_paid_sms = 'admission_fee_paid_sms';
    const Show_subhead_in_payment_slip = 'show_subhead_in_payment_slip';

    const Result_show_by_username = 'result_show_by_username';

    protected $fillable = [
        self::SITE_GROUP_ID,
        self::SITE_NAME,
        self::SHORT_NAME,
        self::ACADEMIC_PERIOD_YPE_IDS,
        self::BOARD,
        self::EIIN,
        self::COLLEGE_CODE,
        self::NU_CODE,
        self::DOMAIN_NAME,
        self::ACADEMIC_GROUP_IDS,
        self::SITE_NAME_NATIVE_LANGUAGE,

        self::Employee_academic_transport_ids,
        self::Employee_academic_residence_ids,
        self::Employee_academic_student_quata_ids,
        self::Emp_grade_ids,
        self::Employee_examination_ids,
        self::ACADEMIC_FISCAL_YEAR_IDS,
        self::COUNTRY,
        self::DIVISION,
        self::DISTRICT,
        self::THANA,
        self::SITE_ADDRESS,
        self::Google_map_address,
        self::SITE_ALIAS,
        self::SITE_EMAIL,
        self::SITE_PHONE,
        self::SITE_LOGO,
        self::EMP_IN_SMS,
        self::EMP_OUT_SMS,
        self::REASON,
        self::STATUS,

        self::ACADEMIC_BOARD_ID,

        self::Admit_card_description,
        self::Std_fee_paid_sms,
        self::HOUSE_IDS,
        self::All_admin_fee_collection_status,
        self::Web_student_fee_collection_status,
        self::Student_fee_collection_status,
        self::Admission_fee_collection_status,
        self::Admission_fee_paid_sms,
        self::Show_subhead_in_payment_slip,
        self::Result_show_by_username,
    ];

    public $ownfields = [
        self::SITE_GROUP_ID,
        self::ACADEMIC_PERIOD_YPE_IDS,
        self::ACADEMIC_GROUP_IDS,
        self::SITE_NAME_NATIVE_LANGUAGE,
        self::COUNTRY,
        self::DIVISION,
        self::DISTRICT,
        self::THANA,
        self::BOARD,
        self::EIIN,
        self::COLLEGE_CODE,
        self::NU_CODE,
        self::DOMAIN_NAME,
        self::Employee_academic_transport_ids,
        self::Employee_academic_residence_ids,
        self::Employee_academic_student_quata_ids,
        self::Emp_grade_ids,
        self::Employee_examination_ids,
        self::ACADEMIC_FISCAL_YEAR_IDS,
        self::SITE_ALIAS,
        self::SITE_EMAIL,
        self::SITE_PHONE,
        self::EMP_IN_SMS,
        self::EMP_OUT_SMS,
        self::REASON,
        self::STATUS,
        self::ACADEMIC_BOARD_ID,
        self::HOUSE_IDS,
    ];


/*

    public function getAcademicYearIdsAttribute($value)
    {

        dd($this->siteInfoSettings());
        return ucfirst($value);
    }*/



    public function academicBoard()
    {
        return $this->belongsTo(AcademicBoard::class);
    }

    public function photo()
    {
        return $this->morphMany(Photo::class, 'imageable');
    }

    public function district()
    {
        return $this->belongsTo(District::class);
    }

    public function siteType()
    {
        return $this->belongsTo(SiteType::class);
    }

    public function siteGroup()
    {
        return $this->belongsTo(GlobalSiteInfo::class);
    }


    public function subModules()
    {
        return $this->belongsToMany(SubModule::class, 'site_accesses', 'site_id', 'sub_module_id');
    }

    public function siteInfoSettings()
    {
        return $this->hasMany(GlobalSiteInfoSetting::class, 'site_id');
    }

    public function siteMembership()
    {
        return $this->hasOne(SiteMembership::class, 'site_id');
    }


    public function getShiftIdsAttribute($values)
    {
        // dd(explode(',', $values));

        return $this->attributes['shift_ids'] = AcademicShift::whereIn('id', explode(',', $values))->get();

        // $this->attributes['password'] = bcrypt($request);


    }



    public function siteWebSiteVisitorDetail()
    {
        return $this->hasMany(SiteWebSiteVisitorDetail::class, 'site_id');
    }

    public function latestVisitor()
    {
        return $this->hasOne(SiteWebSiteVisitorDetail::class, 'site_id')->latest();
    }


    public function globalStudentHistory()
    {
        return $this->hasMany(GlobalStudentHistory::class, 'site_id');
    }

    public function employeeHistory()
    {
        return $this->hasMany(GlobalEmployeeHistory::class, 'site_id');
    }


}


















