<?php

namespace App\Models\Site\SiteInfoSetting;

use App\Models\Academic\AcademicGroup;
use App\Models\Site\Shift\GlobalShiftDetail;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use Illuminate\Database\Eloquent\Model;

class GlobalSiteInfoSetting extends Model
{
    public $timestamps = false;
    public $table = 'site_info_settings';


    const Site_Group_Setting_ID = 'site_group_setting_id';
    const Academic_Group_ID = 'academic_group_id';

    const SITE_ID = 'site_id';
    const ACADEMIC_VERSION_IDs = 'academic_version_ids';
    const ACADEMIC_YEAR_IDs = 'academic_year_ids';
    const ACADEMIC_SESSION_IDs = 'academic_session_ids';
    const ACADEMIC_SESSION_TYPE_IDs = 'academic_session_type_ids';
    const ACADEMIC_STUDENT_CATEGORY_IDs = 'academic_student_category_ids';
    const ACADEMIC_STUDENT_TYPE_IDs = 'academic_student_type_ids';

    const ACADEMIC_FEE_HEAD_IDS = 'academic_fee_head_ids';
    const ACADEMIC_FEE_SUB_HEAD_IDS = 'academic_fee_sub_head_ids';
    const ACADEMIC_FEE_GROUP_IDS = 'academic_fee_group_ids';
    const ACADEMIC_WAIVER_TYPE_IDS = 'academic_waiver_type_ids';
    const ACADEMIC_FEE_STUDENT_OFFER_TYPE_IDS = 'academic_student_offer_type_ids';
    const Emp_exam_committee_position_ids= 'emp_exam_committee_position_ids';
    const EXAMINATION_IDS = 'examination_ids';

    const ACADEMIC_ADMISSION_TYPE_IDs = 'academic_admission_type_ids';
    const ACADEMIC_EXAM_TYPE_IDs = 'academic_exam_type_ids';
    const ACADEMIC_FISCAL_YEAR_IDs = 'academic_fiscal_year_ids';
    const ACADEMIC_LEAVE_TYPE_IDs = 'academic_leave_type_ids';
    const ACADEMIC_LEAVE_CETAGORY_IDs = 'academic_leave_cetagory_ids';
    const ACADEMIC_CALENDAR_HEAD_IDs = 'academic_calendar_head_ids';
    const ACADEMIC_RESULT_PRIMARY_TYPE_IDs = 'academic_result_primary_type_ids';
    const ACADEMIC_RESULT_COMBINE_TYPE_IDs = 'academic_result_combine_type_ids';
    const ACADEMIC_SUBJECT_CLASS_EXAM_CONDITION_IDs = 'academic_subject_class_exam_condition_ids';
    const ACADEMIC_RESULT_SYSTEM_IDs = 'academic_result_system_ids';
    const BATCH_PRESENT_STATUS = 'batch_present_status';

    const Academic_Class_IDs = 'academic_class_ids';
    const Academic_Department_IDs = 'academic_department_ids';
    const Academic_Subject_IDs = 'academic_subject_ids';
    const Academic_Section_IDs = 'academic_section_ids';
    const Academic_Class_Group_IDs = 'academic_class_group_ids';
    const Academic_Subject_Condition_IDs = 'academic_subject_condition_ids';
    const Shift_IDs = 'shift_ids';
    const Gender_IDs = 'gender_ids';
    const Designation_IDs = 'designation_ids';
    const SITE_GOVT_CODE = 'site_govt_code';
    const Religion_IDs = 'religion_ids';
    const Academic_Residence_IDs = 'academic_residence_ids';
    const STATUS = 'status';
    const DEVICE_USING_CLASS = 'device_using_class_ids';

    const EMP_IN_SMS = 'emp_in_sms';
    const EMP_OUT_SMS = 'emp_out_sms';
    const Regards_title = 'regards_title';
    const Absent_sms_txt = 'absent_sms_txt';


    protected $fillable = [
        self::Site_Group_Setting_ID,
        self::ACADEMIC_VERSION_IDs,
        self::ACADEMIC_YEAR_IDs,
        self::ACADEMIC_SESSION_IDs,
        self::ACADEMIC_SESSION_TYPE_IDs,
        self::ACADEMIC_STUDENT_CATEGORY_IDs,
        self::ACADEMIC_STUDENT_TYPE_IDs,
        self::ACADEMIC_FEE_HEAD_IDS,
        self::ACADEMIC_FEE_SUB_HEAD_IDS,
        self::ACADEMIC_FEE_GROUP_IDS,
        self::ACADEMIC_WAIVER_TYPE_IDS,
        self::ACADEMIC_FEE_STUDENT_OFFER_TYPE_IDS,
        self::Emp_exam_committee_position_ids,
        self::EXAMINATION_IDS,
        self::BATCH_PRESENT_STATUS,

        self::ACADEMIC_ADMISSION_TYPE_IDs,
        self::ACADEMIC_EXAM_TYPE_IDs,
        self::ACADEMIC_FISCAL_YEAR_IDs,
        self::ACADEMIC_LEAVE_TYPE_IDs,
        self::ACADEMIC_LEAVE_CETAGORY_IDs,
        self::ACADEMIC_CALENDAR_HEAD_IDs,
        self::ACADEMIC_RESULT_PRIMARY_TYPE_IDs,
        self::ACADEMIC_RESULT_COMBINE_TYPE_IDs,
        self::ACADEMIC_SUBJECT_CLASS_EXAM_CONDITION_IDs,
        self::ACADEMIC_RESULT_SYSTEM_IDs,

        self::SITE_ID,
        self::Academic_Group_ID,
        self::Academic_Class_IDs,
        self::Academic_Department_IDs,
        self::Academic_Subject_IDs,
        self::Shift_IDs,
        self::Gender_IDs,
        self::Religion_IDs,
        self::Designation_IDs,
        self::Academic_Section_IDs,
        self::Academic_Class_Group_IDs,
        self::Academic_Subject_Condition_IDs,
        self::Academic_Residence_IDs,
        self::SITE_GOVT_CODE,
        self::STATUS,
        self::DEVICE_USING_CLASS,
        self::EMP_IN_SMS,
        self::EMP_OUT_SMS,
        self::Regards_title,
        self::Absent_sms_txt,
    ];

    public $ownfields = [
        self::Site_Group_Setting_ID,
        self::ACADEMIC_VERSION_IDs,
        self::ACADEMIC_YEAR_IDs,
        self::ACADEMIC_SESSION_IDs,
        self::ACADEMIC_SESSION_TYPE_IDs,
        self::ACADEMIC_STUDENT_CATEGORY_IDs,
        self::ACADEMIC_STUDENT_TYPE_IDs,
        self::ACADEMIC_FEE_HEAD_IDS,
        self::ACADEMIC_FEE_SUB_HEAD_IDS,
        self::ACADEMIC_FEE_GROUP_IDS,
        self::ACADEMIC_WAIVER_TYPE_IDS,
        self::ACADEMIC_FEE_STUDENT_OFFER_TYPE_IDS,
        self::Emp_exam_committee_position_ids,
        self::EXAMINATION_IDS,

        self::ACADEMIC_ADMISSION_TYPE_IDs,
        self::ACADEMIC_EXAM_TYPE_IDs,
        self::ACADEMIC_FISCAL_YEAR_IDs,
        self::ACADEMIC_LEAVE_TYPE_IDs,
        self::ACADEMIC_LEAVE_CETAGORY_IDs,
        self::ACADEMIC_CALENDAR_HEAD_IDs,
        self::ACADEMIC_RESULT_PRIMARY_TYPE_IDs,
        self::ACADEMIC_RESULT_COMBINE_TYPE_IDs,
        self::ACADEMIC_SUBJECT_CLASS_EXAM_CONDITION_IDs,
        self::ACADEMIC_RESULT_SYSTEM_IDs,
        self::BATCH_PRESENT_STATUS,

        self::SITE_ID,
        self::Academic_Group_ID,
        self::Academic_Class_IDs,
        self::Academic_Department_IDs,
        self::Academic_Subject_IDs,
        self::Shift_IDs,
        self::Gender_IDs,
        self::Religion_IDs,
        self::Designation_IDs,
        self::Academic_Section_IDs,
        self::Academic_Class_Group_IDs,
        self::Academic_Subject_Condition_IDs,
        self::Academic_Residence_IDs,
        self::SITE_GOVT_CODE,
        self::STATUS,
        self::DEVICE_USING_CLASS,
        self::EMP_IN_SMS,
        self::EMP_OUT_SMS,
        self::Regards_title,
        self::Absent_sms_txt,
    ];


    public  function academicGroup()
    {
        return $this->belongsTo(AcademicGroup::class, 'academic_group_id', 'id');
    }


    public  function site()
    {
        return $this->belongsTo(GlobalSiteInfo::class, 'site_id');
    }


    public function activeAbsentSmsShifts()
    {
        return $this->hasMany(GlobalShiftDetail::class, 'site_id','site_id');
    }

}
