<?php

namespace App\Models\Site;

use App\Models\Package\EduPackage;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\User\User;
use App\Models\ProjectModel;

class SiteMembership extends Model
{
    //use SoftDeletes;

    public $timestamps = false;
    protected $table = 'site_memberships';
    protected $dates = ['deleted_at'];

    protected $casts = [
        'status' => 'integer'
    ];


    const EDU_PACKAGE_ID = 'edu_package_id';
    const Service_type = 'service_type';
    const PAYMENT_TYPE = 'payment_type';
    const PAYMENT_AMOUNT = 'payment_amount';
    const PAYMENT_INSTALLMENT = 'payment_installment';
    const LATE_PAYMENT_STATUS = 'late_payment_status';
    const LATE_PAYMENT_DAYS = 'late_payment_days';
    const BILLING_START_DATE = 'billing_start_date';
    const LATE_FEE = 'late_fee';
    const ALUMNI_LOGIN = 'alumni_login';
    const ALUMNI_FEE = 'alumni_fee';
    const DISCOUNT_TYPE = 'discount_type';
    const DISCOUNT = 'discount';
    const SMS_BEARER = 'sms_bearer';
    const SMS_BEARER_ID = 'sms_bearer_id';
    const SMS_BALANCE = 'sms_balance';
    const SMS_SEND_TYPE = 'sms_send_type';
    const SMS_SEND_COMPANY = 'sms_send_company';
    const SMS_COST = 'per_sms_cost';
    const Per_device_bill = 'per_device_bill';
    const Total_device = 'total_device';
    const STATUS = 'status';
    const SITE_ID = 'site_id';

    protected $fillable = [
        self::EDU_PACKAGE_ID,
        self::Service_type,
        self::PAYMENT_TYPE,
        self::PAYMENT_AMOUNT,
        self::BILLING_START_DATE,
        self::PAYMENT_INSTALLMENT,
        self::LATE_PAYMENT_STATUS,
        self::LATE_PAYMENT_DAYS,
        self::LATE_FEE,
        self::ALUMNI_LOGIN,
        self::ALUMNI_FEE,
        self::DISCOUNT_TYPE,
        self::DISCOUNT,
        self::SMS_BEARER,
        self::SMS_SEND_TYPE,
        self::SMS_SEND_COMPANY,
        self::SMS_BEARER_ID,
        self::SMS_BALANCE,
        self::SMS_COST,
        self::Total_device,
        self::Per_device_bill,
        self::SITE_ID,
        self::STATUS,
    ];

    public $ownFields = [
        self::EDU_PACKAGE_ID,
        self::Service_type,
        self::PAYMENT_TYPE,
        self::PAYMENT_AMOUNT,
        self::BILLING_START_DATE,
        self::PAYMENT_INSTALLMENT,
        self::LATE_PAYMENT_STATUS,
        self::LATE_PAYMENT_DAYS,
        self::LATE_FEE,
        self::ALUMNI_LOGIN,
        self::ALUMNI_FEE,
        self::DISCOUNT_TYPE,
        self::SMS_SEND_TYPE,
        self::SMS_SEND_COMPANY,
        self::DISCOUNT,
        self::SMS_BEARER,
        self::SMS_BEARER_ID,
        self::SMS_BALANCE,
        self::SMS_COST,
        self::Per_device_bill,
        self::SITE_ID,
        self::STATUS,
    ];


    public function getSmsInStockAttribute($value)
    {
        return $this->attributes['sms_in_stock'] = $value ?? 0;
    }

    public function setSmsInStockAttribute($value)
    {
        return $this->attributes['sms_in_stock'] = $value ?? 0;
    }


    public function package()
    {
        return $this->belongsTo(EduPackage::class, 'edu_package_id');
    }


}
