<?php

namespace App\Models\Site\Student\Attendance;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicShift;
use App\Models\Site\Batch\BatchDetail;
use App\Models\Site\Batch\GlobalBatchDetail;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class GlobalStudentAbsent extends Model
{

    protected $table = 'site_student_attendance_absents';
    public $timestamps = true;


    const BELONGS_TO = 'belongs_to';
    const ACADEMIC_SHIFT_ID = 'academic_shift_id';
    const SITE_SHIFT_DETAILS_ID = 'site_shift_details_id';
    const ACADEMIC_PERIOD_TYPE_ID = 'academic_period_type_id';
    const BATCH_ID = 'site_batch_detail_id';
    const TOTAL_STUDENT = 'total_student';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const SITE_ID = 'site_id';


    protected $fillable = [

        self::BELONGS_TO,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_PERIOD_TYPE_ID,
        self::TOTAL_STUDENT,
        self::ACADEMIC_GROUP_ID,
        self::ACADEMIC_GROUP_ID,
        self::SITE_ID,
    ];

    protected $ownFields= [

        self::BELONGS_TO,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_PERIOD_TYPE_ID,
        self::TOTAL_STUDENT,
        self::ACADEMIC_GROUP_ID,
        self::ACADEMIC_GROUP_ID,
        self::SITE_ID,
    ];



    public  function shift()
    {
        return $this->belongsTo(AcademicShift::class, 'academic_shift_id');
    }

    public  function batch()
    {
        return $this->belongsTo(GlobalBatchDetail::class, 'site_batch_detail_id');
    }



}
